/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.loader.ExecutableArchiveLauncher;
import org.springframework.boot.loader.LaunchedURLClassLoader;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.thin.ArchiveUtils;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.boot.loader.thin.Level;
import org.springframework.boot.loader.thin.LogUtils;
import org.springframework.boot.loader.thin.PathResolver;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public class ThinJarLauncher
extends ExecutableArchiveLauncher {
    private static final Logger log = LoggerFactory.getLogger(ThinJarLauncher.class);
    public static final String THIN_MAIN = "thin.main";
    public static final String THIN_DRYRUN = "thin.dryrun";
    public static final String THIN_FORCE = "thin.force";
    public static final String THIN_OFFLINE = "thin.offline";
    public static final String THIN_CLASSPATH = "thin.classpath";
    public static final String THIN_ROOT = "thin.root";
    public static final String THIN_ARCHIVE = "thin.archive";
    public static final String THIN_PARENT = "thin.parent";
    public static final String THIN_LOCATION = "thin.location";
    public static final String THIN_NAME = "thin.name";
    public static final String THIN_PROFILE = "thin.profile";
    public static final String THIN_PARENT_FIRST = "thin.parent.first";
    public static final String THIN_PARENT_BOOT = "thin.parent.boot";
    private StandardEnvironment environment = new StandardEnvironment();
    private boolean debug;

    public static void main(String[] args) throws Exception {
        LogUtils.setLogLevel(Level.OFF);
        new ThinJarLauncher(args).launch(args);
    }

    protected ThinJarLauncher(String[] args) throws Exception {
        super(ThinJarLauncher.computeArchive(args));
    }

    protected void launch(String[] args) throws Exception {
        boolean trace;
        this.addCommandLineProperties(args);
        args = this.removeThinArgs(args);
        String root = this.environment.resolvePlaceholders("${thin.root:}");
        String classpathValue = this.environment.resolvePlaceholders("${thin.classpath:false}");
        boolean classpath = "".equals(classpathValue) || "true".equals(classpathValue) || "path".equals(classpathValue);
        boolean compute = "properties".equals(classpathValue);
        boolean bl = trace = !"false".equals(this.environment.resolvePlaceholders("${thin.trace:${trace:false}}"));
        if (classpath || compute) {
            this.debug = false;
            LogUtils.setLogLevel(Level.OFF);
        } else {
            boolean bl2 = this.debug = trace || !"false".equals(this.environment.resolvePlaceholders("${thin.debug:${debug:false}}"));
        }
        if (this.debug || trace) {
            if (trace) {
                LogUtils.setLogLevel(Level.TRACE);
            } else {
                LogUtils.setLogLevel(Level.INFO);
            }
        }
        if (classpath) {
            List<Archive> archives = this.getClassPathArchives();
            System.out.println(this.classpath(archives));
            return;
        }
        if (compute) {
            List<Dependency> dependencies = this.getDependencies();
            System.out.println(this.properties(dependencies));
            return;
        }
        log.info("Version: " + ThinJarLauncher.getVersion());
        if (!"false".equals(this.environment.resolvePlaceholders("${thin.dryrun:false}"))) {
            this.getClassPathArchives(this.environment.resolvePlaceholders("${thin.root:}"));
            log.info("Downloaded dependencies" + (!StringUtils.hasText((String)root) ? "" : " to " + root));
            return;
        }
        super.launch(args);
    }

    protected Iterator<Archive> getClassPathArchivesIterator() throws Exception {
        return this.getClassPathArchives().iterator();
    }

    private static String getVersion() {
        Package pkg = ThinJarLauncher.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    private String[] removeThinArgs(String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        boolean escaped = false;
        for (String arg : args) {
            if ("--".equals(arg)) {
                escaped = true;
                continue;
            }
            if (!escaped && arg.startsWith("--thin.")) continue;
            result.add(arg);
        }
        return result.toArray(new String[0]);
    }

    private String properties(List<Dependency> dependencies) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("computed", "true");
        for (Dependency dependency : dependencies) {
            props.put(this.key(dependency.getArtifact(), props), ThinJarLauncher.coordinates(dependency.getArtifact()));
        }
        StringBuilder builder = new StringBuilder();
        for (String key : props.keySet()) {
            builder.append("dependencies.").append(key).append('=').append((String)props.get(key)).append("\n");
        }
        return builder.toString();
    }

    private String key(Artifact dependency, Map<String, String> props) {
        String key = dependency.getArtifactId();
        if (StringUtils.hasLength((String)dependency.getClassifier())) {
            key = key + "." + dependency.getClassifier();
        }
        int counter = 1;
        while (props.get(key) != null) {
            key = key + "." + counter++;
        }
        return key;
    }

    static String coordinates(Artifact artifact) {
        String classifier = artifact.getClassifier();
        String extension = artifact.getExtension();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + (StringUtils.hasText((String)extension) && (!"jar".equals(extension) || StringUtils.hasText((String)classifier)) ? ":" + extension : "") + (StringUtils.hasText((String)classifier) ? ":" + classifier : "") + ":" + artifact.getVersion();
    }

    private String classpath(List<Archive> archives) throws Exception {
        StringBuilder builder = new StringBuilder();
        String separator = System.getProperty("path.separator");
        Archive local = this.getArchive();
        if (local instanceof ExplodedArchive) {
            for (URL url : ArchiveUtils.nestedClasses(local, "BOOT-INF/classes/")) {
                if (builder.length() > 0) {
                    builder.append(separator);
                }
                builder.append(this.path(url));
            }
        }
        for (Archive archive : archives) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            log.info("Archive: {}", (Object)archive);
            builder.append(this.path(archive.getUrl()));
        }
        return builder.toString();
    }

    private String path(URL url) throws Exception {
        String uri = url.toURI().toString();
        if (uri.startsWith("jar:")) {
            uri = uri.substring("jar:".length());
        }
        if (uri.startsWith("file:")) {
            uri = uri.substring("file:".length());
        }
        if (uri.endsWith("!/")) {
            uri = uri.substring(0, uri.length() - "!/".length());
        }
        return new File(uri).getCanonicalPath();
    }

    private void addCommandLineProperties(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        MutablePropertySources properties = this.environment.getPropertySources();
        SimpleCommandLinePropertySource source = new SimpleCommandLinePropertySource("commandArgs", args);
        if (!properties.contains("commandArgs")) {
            properties.addFirst((PropertySource)source);
        } else {
            properties.replace("commandArgs", (PropertySource)source);
        }
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        if ("true".equals(this.environment.resolvePlaceholders("${thin.parent.boot:true}"))) {
            parent = parent.getParent();
        }
        ThinJarClassLoader loader = new ThinJarClassLoader(ArchiveUtils.addNestedClasses(this.getArchive(), urls, "BOOT-INF/classes/"), parent);
        if ("true".equals(this.environment.resolvePlaceholders("${thin.parent.first:true}"))) {
            loader.setParentFirst(true);
        } else {
            loader.setParentFirst(false);
        }
        LogUtils.setLogLevel(Level.INFO);
        return loader;
    }

    protected String getMainClass() throws Exception {
        String mainClass = this.environment.resolvePlaceholders("${thin.main:}");
        if (StringUtils.hasText((String)mainClass)) {
            return mainClass;
        }
        return ArchiveUtils.findMainClass(this.getArchive());
    }

    protected List<Archive> getClassPathArchives() throws Exception {
        return this.getClassPathArchives(null);
    }

    private List<Archive> getClassPathArchives(String root) throws Exception {
        String parent = this.environment.resolvePlaceholders("${thin.parent:}");
        String name = this.environment.resolvePlaceholders("${thin.name:thin}");
        String[] profiles = this.environment.resolvePlaceholders("${thin.profile:}").split(",");
        PathResolver resolver = this.getResolver();
        Archive parentArchive = null;
        if (StringUtils.hasText((String)parent)) {
            parentArchive = ArchiveUtils.getArchive(parent);
        }
        long t0 = System.currentTimeMillis();
        List<Archive> archives = resolver.resolve(parentArchive, this.getArchive(), name, profiles);
        long t1 = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Dependencies resolved in: " + (t1 - t0) + "ms");
        }
        return archives;
    }

    protected List<Dependency> getDependencies() throws Exception {
        String name = this.environment.resolvePlaceholders("${thin.name:thin}");
        String[] profiles = this.environment.resolvePlaceholders("${thin.profile:}").split(",");
        PathResolver resolver = this.getResolver();
        return resolver.extract(this.getArchive(), name, profiles);
    }

    private PathResolver getResolver() {
        String locations = this.environment.resolvePlaceholders("${thin.location:}");
        String root = this.environment.resolvePlaceholders("${thin.root:}");
        String offline = this.environment.resolvePlaceholders("${thin.offline:false}");
        String force = this.environment.resolvePlaceholders("${thin.force:${thin.dryrun:false}}");
        PathResolver resolver = new PathResolver(DependencyResolver.instance());
        if (StringUtils.hasText((String)locations)) {
            resolver.setLocations(locations.split(","));
        }
        if (StringUtils.hasText((String)root)) {
            resolver.setRoot(root);
            if ("false".equals(this.environment.resolvePlaceholders("${thin.local.snapshots:true}"))) {
                resolver.setPreferLocalSnapshots(false);
            }
        }
        if (!"false".equals(offline)) {
            resolver.setOffline(true);
        }
        if (!"false".equals(force)) {
            resolver.setForce(true);
        }
        resolver.setOverrides(this.getSystemProperties());
        return resolver;
    }

    private Properties getSystemProperties() {
        Properties properties = new Properties();
        try {
            Properties system = System.getProperties();
            for (Object key : system.keySet()) {
                String name = key.toString();
                if (!name.startsWith("thin.properties.")) continue;
                name = name.substring("thin.properties.".length());
                properties.setProperty(name, system.getProperty(key.toString()));
            }
        }
        catch (AccessControlException system) {
            // empty catch block
        }
        if (this.environment.getPropertySources().contains("commandArgs")) {
            SimpleCommandLinePropertySource commandArgs = (SimpleCommandLinePropertySource)this.environment.getPropertySources().get("commandArgs");
            for (String key : commandArgs.getPropertyNames()) {
                String name = key.toString();
                if (!name.startsWith("thin.properties.")) continue;
                name = name.substring("thin.properties.".length());
                properties.setProperty(name, commandArgs.getProperty(key.toString()));
            }
        }
        return properties;
    }

    protected boolean isNestedArchive(Archive.Entry entry) {
        return false;
    }

    private static Archive computeArchive(String[] args) throws Exception {
        String path = ThinJarLauncher.getProperty(THIN_ARCHIVE);
        String prefix = "--thin.archive";
        for (String arg : args) {
            if (!arg.startsWith(prefix)) continue;
            path = arg.length() <= prefix.length() + 1 ? null : arg.substring(prefix.length() + 1);
        }
        return ArchiveUtils.getArchive(path);
    }

    static String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        return System.getenv(key.replace(".", "_").toUpperCase());
    }

    private static class ThinJarClassLoader
    extends LaunchedURLClassLoader {
        private boolean parentFirst = false;

        public ThinJarClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public void setParentFirst(boolean parentFirst) {
            this.parentFirst = parentFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class c = this.findLoadedClass(name);
                if (c == null) {
                    try {
                        if (!this.parentFirst) {
                            return this.findClass(name);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    return super.loadClass(name, resolve);
                }
                return c;
            }
        }

        public URL getResource(String name) {
            URL url = null;
            if (this.parentFirst && (url = this.getParent().getResource(name)) != null) {
                return url;
            }
            url = this.findResource(name);
            if (url != null) {
                return url;
            }
            if (!this.parentFirst && (url = this.getParent().getResource(name)) != null) {
                return url;
            }
            return null;
        }
    }
}

