/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ThinPropertiesModelProcessor
extends DefaultModelProcessor {
    static final String DEFAULT_EXTENSION = "jar";
    static final String EMPTY_CLASSIFIER = "";

    ThinPropertiesModelProcessor() {
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model model = super.read(input, options);
        return this.process(model);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model model = super.read(input, options);
        return this.process(model);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        try {
            Model model = super.read((InputStream)new BufferedInputStream(input){

                @Override
                public void close() throws IOException {
                }
            }, options);
            Model model2 = this.process(model);
            return model2;
        }
        finally {
            input.close();
        }
    }

    private Model process(Model model) {
        Properties properties = DependencyResolver.getGlobals();
        return ThinPropertiesModelProcessor.process(model, properties);
    }

    static Model process(Model model, Properties properties) {
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                String pom;
                DefaultArtifact artifact;
                if (name.startsWith("boms.")) {
                    String bom = properties.getProperty(name);
                    artifact = ThinPropertiesModelProcessor.artifact(bom);
                    if (model.getDependencyManagement() == null) {
                        model.setDependencyManagement(new DependencyManagement());
                    }
                    boolean replaced = false;
                    for (Dependency dependency : model.getDependencyManagement().getDependencies()) {
                        if (!ObjectUtils.nullSafeEquals((Object)artifact.getArtifactId(), (Object)dependency.getArtifactId()) || !ObjectUtils.nullSafeEquals((Object)artifact.getGroupId(), (Object)dependency.getGroupId())) continue;
                        dependency.setVersion(artifact.getVersion());
                    }
                    if (ThinPropertiesModelProcessor.isParentBom(model, artifact)) {
                        model.getParent().setVersion(artifact.getVersion());
                        replaced = true;
                    }
                    if (replaced) continue;
                    model.getDependencyManagement().addDependency(ThinPropertiesModelProcessor.bom(artifact));
                    continue;
                }
                if (name.startsWith("dependencies.")) {
                    pom = properties.getProperty(name);
                    artifact = ThinPropertiesModelProcessor.artifact(pom);
                    boolean replaced = false;
                    for (Dependency dependency : model.getDependencies()) {
                        if (!ObjectUtils.nullSafeEquals((Object)artifact.getArtifactId(), (Object)dependency.getArtifactId()) || !ObjectUtils.nullSafeEquals((Object)artifact.getGroupId(), (Object)dependency.getGroupId()) || artifact.getVersion() == null) continue;
                        dependency.setVersion(StringUtils.hasLength((String)artifact.getVersion()) ? artifact.getVersion() : null);
                        dependency.setScope("runtime");
                        replaced = true;
                    }
                    if (replaced) continue;
                    model.getDependencies().add(ThinPropertiesModelProcessor.dependency(artifact));
                    continue;
                }
                if (!name.startsWith("exclusions.")) continue;
                pom = properties.getProperty(name);
                Exclusion exclusion = ThinPropertiesModelProcessor.exclusion(pom);
                Dependency target = ThinPropertiesModelProcessor.dependency(ThinPropertiesModelProcessor.artifact(pom));
                Dependency excluded = null;
                for (Dependency dependency : model.getDependencies()) {
                    dependency.addExclusion(exclusion);
                    if (!dependency.getGroupId().equals(target.getGroupId()) || !dependency.getArtifactId().equals(target.getArtifactId())) continue;
                    excluded = dependency;
                }
                if (excluded == null) continue;
                model.getDependencies().remove(excluded);
            }
        }
        return model;
    }

    private static Exclusion exclusion(String pom) {
        Exclusion exclusion = new Exclusion();
        DefaultArtifact artifact = ThinPropertiesModelProcessor.artifact(pom);
        exclusion.setGroupId(artifact.getGroupId());
        exclusion.setArtifactId(artifact.getArtifactId());
        return exclusion;
    }

    private static Dependency bom(DefaultArtifact artifact) {
        Dependency result = ThinPropertiesModelProcessor.dependency(artifact);
        result.setType("pom");
        result.setScope("import");
        return result;
    }

    private static boolean isParentBom(Model model, DefaultArtifact artifact) {
        if (model.getParent() == null) {
            return false;
        }
        if (ObjectUtils.nullSafeEquals((Object)artifact.getArtifactId(), (Object)model.getParent().getArtifactId()) && ObjectUtils.nullSafeEquals((Object)artifact.getGroupId(), (Object)model.getParent().getGroupId())) {
            return true;
        }
        return ObjectUtils.nullSafeEquals((Object)"spring-boot-starter-parent", (Object)model.getParent().getArtifactId()) && ObjectUtils.nullSafeEquals((Object)artifact.getArtifactId(), (Object)"spring-boot-dependencies");
    }

    private static Dependency dependency(DefaultArtifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(StringUtils.hasLength((String)artifact.getVersion()) ? artifact.getVersion() : null);
        dependency.setClassifier(StringUtils.hasLength((String)artifact.getClassifier()) ? artifact.getClassifier() : null);
        dependency.setType(artifact.getExtension());
        return dependency;
    }

    private static DefaultArtifact artifact(String coordinates) {
        String version;
        Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
        Matcher m = p.matcher(coordinates);
        Assert.isTrue((boolean)m.matches(), (String)("Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]][:<version>]"));
        String groupId = m.group(1);
        String artifactId = m.group(2);
        String extension = DEFAULT_EXTENSION;
        String classifier = EMPTY_CLASSIFIER;
        if (StringUtils.hasLength((String)m.group(6))) {
            if (StringUtils.hasLength((String)m.group(4))) {
                extension = m.group(4);
            }
            classifier = m.group(6);
            version = StringUtils.hasLength((String)m.group(8)) ? m.group(8) : null;
        } else {
            version = StringUtils.hasLength((String)m.group(4)) ? m.group(4) : null;
        }
        return new DefaultArtifact(groupId, artifactId, classifier, extension, version);
    }
}

