/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.testcontainers;

import java.net.URI;
import java.util.List;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.RabbitMQContainer;

class RabbitContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<RabbitMQContainer, RabbitConnectionDetails> {
    RabbitContainerConnectionDetailsFactory() {
    }

    protected RabbitConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
        return new RabbitMqContainerConnectionDetails(source);
    }

    private static final class RabbitMqContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<RabbitMQContainer>
    implements RabbitConnectionDetails {
        private RabbitMqContainerConnectionDetails(ContainerConnectionSource<RabbitMQContainer> source) {
            super(source);
        }

        @Override
        public String getUsername() {
            return ((RabbitMQContainer)this.getContainer()).getAdminUsername();
        }

        @Override
        public String getPassword() {
            return ((RabbitMQContainer)this.getContainer()).getAdminPassword();
        }

        @Override
        public List<RabbitConnectionDetails.Address> getAddresses() {
            URI uri = URI.create(this.getSslBundle() != null ? ((RabbitMQContainer)this.getContainer()).getAmqpsUrl() : ((RabbitMQContainer)this.getContainer()).getAmqpUrl());
            return List.of(new RabbitConnectionDetails.Address(uri.getHost(), uri.getPort()));
        }

        @Override
        public SslBundle getSslBundle() {
            return super.getSslBundle();
        }
    }
}

