/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.AllowedListDeserializingMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.amqp.autoconfigure.RabbitRetryTemplateSettings;
import org.springframework.boot.amqp.autoconfigure.RabbitTemplateRetrySettingsCustomizer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.core.retry.RetryListener;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.core.retry.support.CompositeRetryListener;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RabbitTemplateConfigurer {
    private @Nullable MessageConverter messageConverter;
    private @Nullable List<RabbitTemplateRetrySettingsCustomizer> retrySettingsCustomizers;
    private final RabbitProperties rabbitProperties;

    public RabbitTemplateConfigurer(RabbitProperties rabbitProperties) {
        Assert.notNull((Object)rabbitProperties, (String)"'rabbitProperties' must not be null");
        this.rabbitProperties = rabbitProperties;
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setRetrySettingsCustomizers(@Nullable List<RabbitTemplateRetrySettingsCustomizer> retrySettingsCustomizers) {
        this.retrySettingsCustomizers = retrySettingsCustomizers;
    }

    protected final RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public void configure(RabbitTemplate template, ConnectionFactory connectionFactory) {
        PropertyMapper map = PropertyMapper.get();
        template.setConnectionFactory(connectionFactory);
        if (this.messageConverter != null) {
            template.setMessageConverter(this.messageConverter);
        }
        template.setMandatory(this.determineMandatoryFlag());
        RabbitProperties.Template templateProperties = this.rabbitProperties.getTemplate();
        if (templateProperties.getRetry().isEnabled()) {
            template.setRetryTemplate(this.createRetryTemplate(templateProperties.getRetry()));
        }
        map.from(templateProperties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReceiveTimeout(arg_0));
        map.from(templateProperties::getReplyTimeout).as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReplyTimeout(arg_0));
        map.from(templateProperties::getExchange).to(arg_0 -> ((RabbitTemplate)template).setExchange(arg_0));
        map.from(templateProperties::getRoutingKey).to(arg_0 -> ((RabbitTemplate)template).setRoutingKey(arg_0));
        map.from(templateProperties::getDefaultReceiveQueue).to(arg_0 -> ((RabbitTemplate)template).setDefaultReceiveQueue(arg_0));
        map.from(templateProperties::isObservationEnabled).to(arg_0 -> ((RabbitTemplate)template).setObservationEnabled(arg_0));
        map.from(templateProperties::getAllowedListPatterns).whenNot(CollectionUtils::isEmpty).to(allowedListPatterns -> this.setAllowedListPatterns(template.getMessageConverter(), (List<String>)allowedListPatterns));
    }

    protected RetryTemplate createRetryTemplate(RabbitProperties.Retry properties) {
        RabbitRetryTemplateSettings retrySettings = new RabbitRetryTemplateSettings(properties.initializeRetryPolicySettings());
        if (this.retrySettingsCustomizers != null) {
            for (RabbitTemplateRetrySettingsCustomizer customizer : this.retrySettingsCustomizers) {
                customizer.customize(retrySettings);
            }
        }
        RetryPolicy retryPolicy = retrySettings.getRetryPolicySettings().createRetryPolicy();
        RetryListener retryListener = this.createRetryListener(retrySettings.getRetryListeners());
        RetryTemplate retryTemplate = new RetryTemplate(retryPolicy);
        if (retryListener != null) {
            retryTemplate.setRetryListener(retryListener);
        }
        return retryTemplate;
    }

    private @Nullable RetryListener createRetryListener(List<RetryListener> configuredListeners) {
        if (configuredListeners.size() > 1) {
            return new CompositeRetryListener(configuredListeners);
        }
        if (configuredListeners.size() == 1) {
            return configuredListeners.get(0);
        }
        return null;
    }

    private void setAllowedListPatterns(MessageConverter messageConverter, List<String> allowedListPatterns) {
        if (messageConverter instanceof AllowedListDeserializingMessageConverter) {
            AllowedListDeserializingMessageConverter allowedListDeserializingMessageConverter = (AllowedListDeserializingMessageConverter)messageConverter;
            allowedListDeserializingMessageConverter.setAllowedListPatterns(allowedListPatterns);
            return;
        }
        throw new InvalidConfigurationPropertyValueException("spring.rabbitmq.template.allowed-list-patterns", allowedListPatterns, "Allowed list patterns can only be applied to an AllowedListDeserializingMessageConverter");
    }

    private boolean determineMandatoryFlag() {
        Boolean mandatory = this.rabbitProperties.getTemplate().getMandatory();
        return mandatory != null ? mandatory.booleanValue() : this.rabbitProperties.isPublisherReturns();
    }
}

