/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;

public abstract class MainClassFinder {
    private static final String DOT_CLASS = ".class";
    private static final Type STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type MAIN_METHOD_TYPE = Type.getMethodType(Type.VOID_TYPE, STRING_ARRAY_TYPE);
    private static final String MAIN_METHOD_NAME = "main";
    private static final FileFilter CLASS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(MainClassFinder.DOT_CLASS);
        }
    };
    private static final FileFilter PACKAGE_FOLDER_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith(".");
        }
    };

    public static String findMainClass(File rootFolder) throws IOException {
        return MainClassFinder.doWithMainClasses(rootFolder, new MainClassCallback<String>(){

            @Override
            public String doWith(MainClass mainClass) {
                return mainClass.getName();
            }
        });
    }

    public static String findSingleMainClass(File rootFolder) throws IOException {
        return MainClassFinder.findSingleMainClass(rootFolder, null);
    }

    public static String findSingleMainClass(File rootFolder, String annotationName) throws IOException {
        SingleMainClassCallback callback = new SingleMainClassCallback(annotationName);
        MainClassFinder.doWithMainClasses(rootFolder, callback);
        return callback.getMainClassName();
    }

    public static String findSingleMainClass(Collection<File> rootFolders, String annotationName) throws IOException {
        SingleMainClassCallback callback = new SingleMainClassCallback(annotationName);
        MainClassFinder.doWithMainClasses(rootFolders, callback);
        return callback.getMainClassName();
    }

    static <T> T doWithMainClasses(Collection<File> rootFolders, MainClassCallback<T> callback) throws IOException {
        for (File rootFolder : rootFolders) {
            T result = MainClassFinder.doWithMainClasses(rootFolder, callback);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T doWithMainClasses(File rootFolder, MainClassCallback<T> callback) throws IOException {
        if (!rootFolder.exists()) {
            return null;
        }
        if (!rootFolder.isDirectory()) {
            throw new IllegalArgumentException("Invalid root folder '" + rootFolder + "'");
        }
        String prefix = rootFolder.getAbsolutePath() + "/";
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(rootFolder);
        while (!stack.isEmpty()) {
            File file = (File)stack.pop();
            if (file.isFile()) {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    String className;
                    T result;
                    ClassDescriptor classDescriptor = MainClassFinder.createClassDescriptor(inputStream);
                    if (classDescriptor != null && classDescriptor.isMainMethodFound() && (result = callback.doWith(new MainClass(className = MainClassFinder.convertToClassName(file.getAbsolutePath(), prefix), classDescriptor.getAnnotationNames()))) != null) {
                        T t = result;
                        return t;
                    }
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            if (!file.isDirectory()) continue;
            MainClassFinder.pushAllSorted(stack, file.listFiles(PACKAGE_FOLDER_FILTER));
            MainClassFinder.pushAllSorted(stack, file.listFiles(CLASS_FILE_FILTER));
        }
        return null;
    }

    private static void pushAllSorted(Deque<File> stack, File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : files) {
            stack.push(file);
        }
    }

    public static String findMainClass(JarFile jarFile, String classesLocation) throws IOException {
        return MainClassFinder.doWithMainClasses(jarFile, classesLocation, new MainClassCallback<String>(){

            @Override
            public String doWith(MainClass mainClass) {
                return mainClass.getName();
            }
        });
    }

    public static String findSingleMainClass(JarFile jarFile, String classesLocation) throws IOException {
        return MainClassFinder.findSingleMainClass(jarFile, classesLocation, null);
    }

    public static String findSingleMainClass(JarFile jarFile, String classesLocation, String annotationName) throws IOException {
        SingleMainClassCallback callback = new SingleMainClassCallback(annotationName);
        MainClassFinder.doWithMainClasses(jarFile, classesLocation, callback);
        return callback.getMainClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T doWithMainClasses(JarFile jarFile, String classesLocation, MainClassCallback<T> callback) throws IOException {
        List<JarEntry> classEntries = MainClassFinder.getClassEntries(jarFile, classesLocation);
        Collections.sort(classEntries, new ClassEntryComparator());
        for (JarEntry entry : classEntries) {
            BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(entry));
            try {
                String className;
                T result;
                ClassDescriptor classDescriptor = MainClassFinder.createClassDescriptor(inputStream);
                if (classDescriptor == null || !classDescriptor.isMainMethodFound() || (result = callback.doWith(new MainClass(className = MainClassFinder.convertToClassName(entry.getName(), classesLocation), classDescriptor.getAnnotationNames()))) == null) continue;
                T t = result;
                return t;
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        return null;
    }

    private static String convertToClassName(String name, String prefix) {
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        name = name.substring(0, name.length() - DOT_CLASS.length());
        if (prefix != null) {
            name = name.substring(prefix.length());
        }
        return name;
    }

    private static List<JarEntry> getClassEntries(JarFile source, String classesLocation) {
        classesLocation = classesLocation != null ? classesLocation : "";
        Enumeration<JarEntry> sourceEntries = source.entries();
        ArrayList<JarEntry> classEntries = new ArrayList<JarEntry>();
        while (sourceEntries.hasMoreElements()) {
            JarEntry entry = sourceEntries.nextElement();
            if (!entry.getName().startsWith(classesLocation) || !entry.getName().endsWith(DOT_CLASS)) continue;
            classEntries.add(entry);
        }
        return classEntries;
    }

    private static ClassDescriptor createClassDescriptor(InputStream inputStream) {
        try {
            ClassReader classReader = new ClassReader(inputStream);
            ClassDescriptor classDescriptor = new ClassDescriptor();
            classReader.accept(classDescriptor, 1);
            return classDescriptor;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static final class SingleMainClassCallback
    implements MainClassCallback<Object> {
        private final Set<MainClass> mainClasses = new LinkedHashSet<MainClass>();
        private final String annotationName;

        private SingleMainClassCallback(String annotationName) {
            this.annotationName = annotationName;
        }

        @Override
        public Object doWith(MainClass mainClass) {
            this.mainClasses.add(mainClass);
            return null;
        }

        private String getMainClassName() {
            LinkedHashSet<MainClass> matchingMainClasses = new LinkedHashSet<MainClass>();
            if (this.annotationName != null) {
                for (MainClass mainClass : this.mainClasses) {
                    if (!mainClass.getAnnotationNames().contains(this.annotationName)) continue;
                    matchingMainClasses.add(mainClass);
                }
            }
            if (matchingMainClasses.isEmpty()) {
                matchingMainClasses.addAll(this.mainClasses);
            }
            if (matchingMainClasses.size() > 1) {
                throw new IllegalStateException("Unable to find a single main class from the following candidates " + matchingMainClasses);
            }
            return matchingMainClasses.isEmpty() ? null : ((MainClass)matchingMainClasses.iterator().next()).getName();
        }
    }

    static final class MainClass {
        private final String name;
        private final Set<String> annotationNames;

        MainClass(String name, Set<String> annotationNames) {
            this.name = name;
            this.annotationNames = Collections.unmodifiableSet(new HashSet<String>(annotationNames));
        }

        String getName() {
            return this.name;
        }

        Set<String> getAnnotationNames() {
            return this.annotationNames;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MainClass other = (MainClass)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    static interface MainClassCallback<T> {
        public T doWith(MainClass var1);
    }

    private static class ClassDescriptor
    extends ClassVisitor {
        private final Set<String> annotationNames = new LinkedHashSet<String>();
        private boolean mainMethodFound;

        ClassDescriptor() {
            super(262144);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.annotationNames.add(Type.getType(desc).getClassName());
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.isAccess(access, 1, 8) && MainClassFinder.MAIN_METHOD_NAME.equals(name) && MAIN_METHOD_TYPE.getDescriptor().equals(desc)) {
                this.mainMethodFound = true;
            }
            return null;
        }

        private boolean isAccess(int access, int ... requiredOpsCodes) {
            for (int requiredOpsCode : requiredOpsCodes) {
                if ((access & requiredOpsCode) != 0) continue;
                return false;
            }
            return true;
        }

        boolean isMainMethodFound() {
            return this.mainMethodFound;
        }

        Set<String> getAnnotationNames() {
            return this.annotationNames;
        }
    }

    private static class ClassEntryComparator
    implements Comparator<JarEntry> {
        private ClassEntryComparator() {
        }

        @Override
        public int compare(JarEntry o1, JarEntry o2) {
            Integer d2;
            Integer d1 = this.getDepth(o1);
            int depthCompare = d1.compareTo(d2 = Integer.valueOf(this.getDepth(o2)));
            if (depthCompare != 0) {
                return depthCompare;
            }
            return o1.getName().compareTo(o2.getName());
        }

        private int getDepth(JarEntry entry) {
            return entry.getName().split("/").length;
        }
    }
}

