/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.artemis.testcontainers;

import org.springframework.boot.artemis.autoconfigure.ArtemisConnectionDetails;
import org.springframework.boot.artemis.autoconfigure.ArtemisMode;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.activemq.ArtemisContainer;

class ArtemisContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ArtemisContainer, ArtemisConnectionDetails> {
    ArtemisContainerConnectionDetailsFactory() {
    }

    protected ArtemisConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ArtemisContainer> source) {
        return new ArtemisContainerConnectionDetails(source);
    }

    private static final class ArtemisContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ArtemisContainer>
    implements ArtemisConnectionDetails {
        private ArtemisContainerConnectionDetails(ContainerConnectionSource<ArtemisContainer> source) {
            super(source);
        }

        @Override
        public ArtemisMode getMode() {
            return ArtemisMode.NATIVE;
        }

        @Override
        public String getBrokerUrl() {
            return ((ArtemisContainer)this.getContainer()).getBrokerUrl();
        }

        @Override
        public String getUser() {
            return ((ArtemisContainer)this.getContainer()).getUser();
        }

        @Override
        public String getPassword() {
            return ((ArtemisContainer)this.getContainer()).getPassword();
        }
    }
}

