/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.autoconfigure.jdbc.DriverClassNameProvider;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.util.ClassUtils;

public class DataSourceBuilder {
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"org.apache.tomcat.jdbc.pool.DataSource", "com.zaxxer.hikari.HikariDataSource", "org.apache.commons.dbcp.BasicDataSource"};
    private Class<? extends DataSource> type;
    private ClassLoader classLoader;
    private DriverClassNameProvider driverClassNameProvider = new DriverClassNameProvider();
    private Map<String, String> properties = new HashMap<String, String>();

    public static DataSourceBuilder create() {
        return new DataSourceBuilder(null);
    }

    public static DataSourceBuilder create(ClassLoader classLoader) {
        return new DataSourceBuilder(classLoader);
    }

    public DataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public DataSource build() {
        Class<? extends DataSource> type = this.getType();
        DataSource result = (DataSource)BeanUtils.instantiate(type);
        this.maybeGetDriverClassName();
        this.bind(result);
        return result;
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String cls = this.driverClassNameProvider.getDriverClassName(this.properties.get("url"));
            this.properties.put("driverClassName", cls);
        }
    }

    private void bind(DataSource result) {
        new RelaxedDataBinder((Object)result).bind(this.getPropertyValues());
    }

    private PropertyValues getPropertyValues() {
        if (this.getType().getName().contains("Hikari") && this.properties.containsKey("url")) {
            this.properties.put("jdbcUrl", this.properties.get("url"));
            this.properties.remove("url");
        }
        return new MutablePropertyValues(this.properties);
    }

    public DataSourceBuilder type(Class<? extends DataSource> type) {
        this.type = type;
        return this;
    }

    public DataSourceBuilder url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DataSourceBuilder driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public DataSourceBuilder username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DataSourceBuilder password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public Class<? extends DataSource> findType() {
        if (this.type != null) {
            return this.type;
        }
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            if (!ClassUtils.isPresent((String)name, (ClassLoader)this.classLoader)) continue;
            Class resolved = ClassUtils.resolveClassName((String)name, (ClassLoader)this.classLoader);
            return resolved;
        }
        return null;
    }

    private Class<? extends DataSource> getType() {
        Class<? extends DataSource> type = this.findType();
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("No supported DataSource type found");
    }
}

