/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.web.servlet.View;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, FacebookConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.facebook.", value={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class FacebookAutoConfiguration {

    @Configuration
    @EnableSocial
    @ConditionalOnWebApplication
    protected static class FacebookAutoConfigurationAdapter
    extends SocialAutoConfigurerAdapter {
        protected FacebookAutoConfigurationAdapter() {
        }

        @Override
        protected String getPropertyPrefix() {
            return "spring.social.facebook.";
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory(RelaxedPropertyResolver properties) {
            return new FacebookConnectionFactory(properties.getRequiredProperty("app-id"), properties.getRequiredProperty("app-secret"));
        }

        @Bean
        @ConditionalOnMissingBean(value={Facebook.class})
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public Facebook facebook(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(Facebook.class);
            return connection != null ? (Facebook)connection.getApi() : new FacebookTemplate();
        }

        @Bean(name={"connect/facebookConnect", "connect/facebookConnected"})
        @ConditionalOnProperty(prefix="spring.social.", value={"auto-connection-views"})
        public View facebookConnectView() {
            return new GenericConnectionStatusView("facebook", "Facebook");
        }
    }
}

