/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.validation;

import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.validation.DefaultValidatorConfiguration;
import org.springframework.boot.autoconfigure.validation.Jsr303ValidatorAdapterConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@ConditionalOnClass(value={ExecutableValidator.class})
@ConditionalOnResource(resources={"classpath:META-INF/services/javax.validation.spi.ValidationProvider"})
@Import(value={DefaultValidatorConfiguration.class, Jsr303ValidatorAdapterConfiguration.class})
public class ValidationAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Validator.class})
    @ConditionalOnMissingBean
    public static MethodValidationPostProcessor methodValidationPostProcessor(Environment environment, Validator validator) {
        MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
        processor.setProxyTargetClass(ValidationAutoConfiguration.determineProxyTargetClass(environment));
        processor.setValidator(validator);
        return processor;
    }

    private static boolean determineProxyTargetClass(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.aop.");
        Boolean value = (Boolean)resolver.getProperty("proxyTargetClass", Boolean.class);
        return value != null ? value : true;
    }
}

