/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.cache.HazelcastJCacheCustomizationConfiguration;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.boot.autoconfigure.cache.JCachePropertiesCustomizer;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Caching.class, JCacheCacheManager.class})
@ConditionalOnMissingBean(value={org.springframework.cache.CacheManager.class})
@Conditional(value={CacheCondition.class, JCacheAvailableCondition.class})
@Import(value={HazelcastJCacheCustomizationConfiguration.class})
class JCacheCacheConfiguration {
    private final CacheProperties cacheProperties;
    private final CacheManagerCustomizers customizers;
    private final javax.cache.configuration.Configuration<?, ?> defaultCacheConfiguration;
    private final List<JCacheManagerCustomizer> cacheManagerCustomizers;
    private final List<JCachePropertiesCustomizer> cachePropertiesCustomizers;

    JCacheCacheConfiguration(CacheProperties cacheProperties, CacheManagerCustomizers customizers, ObjectProvider<javax.cache.configuration.Configuration<?, ?>> defaultCacheConfiguration, ObjectProvider<List<JCacheManagerCustomizer>> cacheManagerCustomizers, ObjectProvider<List<JCachePropertiesCustomizer>> cachePropertiesCustomizers) {
        this.cacheProperties = cacheProperties;
        this.customizers = customizers;
        this.defaultCacheConfiguration = (javax.cache.configuration.Configuration)defaultCacheConfiguration.getIfAvailable();
        this.cacheManagerCustomizers = (List)cacheManagerCustomizers.getIfAvailable();
        this.cachePropertiesCustomizers = (List)cachePropertiesCustomizers.getIfAvailable();
    }

    @Bean
    public JCacheCacheManager cacheManager(CacheManager jCacheCacheManager) {
        JCacheCacheManager cacheManager = new JCacheCacheManager(jCacheCacheManager);
        return this.customizers.customize(cacheManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheManager jCacheCacheManager() throws IOException {
        CacheManager jCacheCacheManager = this.createCacheManager();
        List<String> cacheNames = this.cacheProperties.getCacheNames();
        if (!CollectionUtils.isEmpty(cacheNames)) {
            for (String cacheName : cacheNames) {
                jCacheCacheManager.createCache(cacheName, this.getDefaultCacheConfiguration());
            }
        }
        this.customize(jCacheCacheManager);
        return jCacheCacheManager;
    }

    private CacheManager createCacheManager() throws IOException {
        CachingProvider cachingProvider = this.getCachingProvider(this.cacheProperties.getJcache().getProvider());
        Properties properties = this.createCacheManagerProperties();
        Resource configLocation = this.cacheProperties.resolveConfigLocation(this.cacheProperties.getJcache().getConfig());
        if (configLocation != null) {
            return cachingProvider.getCacheManager(configLocation.getURI(), cachingProvider.getDefaultClassLoader(), properties);
        }
        return cachingProvider.getCacheManager(null, null, properties);
    }

    private CachingProvider getCachingProvider(String cachingProviderFqn) {
        if (StringUtils.hasText((String)cachingProviderFqn)) {
            return Caching.getCachingProvider((String)cachingProviderFqn);
        }
        return Caching.getCachingProvider();
    }

    private Properties createCacheManagerProperties() {
        Properties properties = new Properties();
        if (this.cachePropertiesCustomizers != null) {
            for (JCachePropertiesCustomizer customizer : this.cachePropertiesCustomizers) {
                customizer.customize(this.cacheProperties, properties);
            }
        }
        return properties;
    }

    private javax.cache.configuration.Configuration<?, ?> getDefaultCacheConfiguration() {
        if (this.defaultCacheConfiguration != null) {
            return this.defaultCacheConfiguration;
        }
        return new MutableConfiguration();
    }

    private void customize(CacheManager cacheManager) {
        if (this.cacheManagerCustomizers != null) {
            AnnotationAwareOrderComparator.sort(this.cacheManagerCustomizers);
            for (JCacheManagerCustomizer customizer : this.cacheManagerCustomizers) {
                customizer.customize(cacheManager);
            }
        }
    }

    @Order(value=0x7FFFFFFF)
    static class JCacheProviderAvailableCondition
    extends SpringBootCondition {
        JCacheProviderAvailableCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition("JCache", new Object[0]);
            String providerProperty = "spring.cache.jcache.provider";
            if (context.getEnvironment().containsProperty(providerProperty)) {
                return ConditionOutcome.match(message.because("JCache provider specified"));
            }
            Iterator providers = Caching.getCachingProviders().iterator();
            if (!providers.hasNext()) {
                return ConditionOutcome.noMatch(message.didNotFind("JSR-107 provider").atAll());
            }
            providers.next();
            if (providers.hasNext()) {
                return ConditionOutcome.noMatch(message.foundExactly("multiple JSR-107 providers"));
            }
            return ConditionOutcome.match(message.foundExactly("single JSR-107 provider"));
        }
    }

    @Order(value=0x7FFFFFFF)
    static class JCacheAvailableCondition
    extends AnyNestedCondition {
        JCacheAvailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnSingleCandidate(value=CacheManager.class)
        static class CustomJCacheCacheManager {
            CustomJCacheCacheManager() {
            }
        }

        @Conditional(value={JCacheProviderAvailableCondition.class})
        static class JCacheProvider {
            JCacheProvider() {
            }
        }
    }
}

