/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource.reactive;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.IssuerUriCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;

@Configuration
class ReactiveOAuth2ResourceServerJwkConfiguration {
    private final OAuth2ResourceServerProperties properties;

    ReactiveOAuth2ResourceServerJwkConfiguration(OAuth2ResourceServerProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.jwt.jwk-set-uri"})
    @ConditionalOnMissingBean
    public ReactiveJwtDecoder jwtDecoder() {
        NimbusReactiveJwtDecoder nimbusReactiveJwtDecoder = new NimbusReactiveJwtDecoder(this.properties.getJwt().getJwkSetUri());
        String issuerUri = this.properties.getJwt().getIssuerUri();
        if (issuerUri != null) {
            nimbusReactiveJwtDecoder.setJwtValidator(JwtValidators.createDefaultWithIssuer((String)issuerUri));
        }
        return nimbusReactiveJwtDecoder;
    }

    @Bean
    @Conditional(value={IssuerUriCondition.class})
    @ConditionalOnMissingBean
    public ReactiveJwtDecoder jwtDecoderByIssuerUri() {
        return ReactiveJwtDecoders.fromOidcIssuerLocation((String)this.properties.getJwt().getIssuerUri());
    }
}

