/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

final class BeanTypeRegistry
implements SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(BeanTypeRegistry.class);
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private static final String BEAN_NAME = BeanTypeRegistry.class.getName();
    private final DefaultListableBeanFactory beanFactory;
    private final Map<String, ResolvableType> beanTypes = new HashMap<String, ResolvableType>();
    private final Map<String, RootBeanDefinition> beanDefinitions = new HashMap<String, RootBeanDefinition>();

    private BeanTypeRegistry(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Set<String> getNamesForType(Class<?> type, TypeExtractor typeExtractor) {
        this.updateTypesIfNecessary();
        return this.beanTypes.entrySet().stream().filter(entry -> {
            Class<?> beanType = this.extractType((ResolvableType)entry.getValue(), typeExtractor);
            return beanType != null && type.isAssignableFrom(beanType);
        }).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Class<?> extractType(ResolvableType type, TypeExtractor extractor) {
        return type != null ? extractor.getBeanType(type) : null;
    }

    public Set<String> getNamesForAnnotation(Class<? extends Annotation> annotation) {
        this.updateTypesIfNecessary();
        return this.beanTypes.entrySet().stream().filter(entry -> entry.getValue() != null && AnnotationUtils.findAnnotation((Class)((ResolvableType)entry.getValue()).resolve(), (Class)annotation) != null).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void afterSingletonsInstantiated() {
        this.beanTypes.clear();
        this.beanDefinitions.clear();
    }

    private void updateTypesIfNecessary() {
        this.beanFactory.getBeanNamesIterator().forEachRemaining(this::updateTypesIfNecessary);
    }

    private void updateTypesIfNecessary(String name) {
        if (!this.beanTypes.containsKey(name)) {
            this.addBeanType(name);
        } else {
            this.updateBeanType(name);
        }
    }

    private void addBeanType(String name) {
        if (this.beanFactory.containsSingleton(name)) {
            this.beanTypes.put(name, this.getType(name, null));
        } else if (!this.beanFactory.isAlias(name)) {
            this.addBeanTypeForNonAliasDefinition(name);
        }
    }

    private void addBeanTypeForNonAliasDefinition(String name) {
        RootBeanDefinition definition = this.getBeanDefinition(name);
        if (definition != null) {
            this.addBeanTypeForNonAliasDefinition(name, definition);
        }
    }

    private void updateBeanType(String name) {
        if (this.beanFactory.isAlias(name) || this.beanFactory.containsSingleton(name)) {
            return;
        }
        RootBeanDefinition definition = this.getBeanDefinition(name);
        if (definition == null) {
            return;
        }
        RootBeanDefinition previous = this.beanDefinitions.put(name, definition);
        if (previous != null && !definition.equals((Object)previous)) {
            this.addBeanTypeForNonAliasDefinition(name, definition);
        }
    }

    private RootBeanDefinition getBeanDefinition(String name) {
        try {
            return (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(name);
        }
        catch (BeanDefinitionStoreException ex) {
            this.logIgnoredError("unresolvable metadata in bean definition", name, (Exception)((Object)ex));
            return null;
        }
    }

    private void addBeanTypeForNonAliasDefinition(String name, RootBeanDefinition definition) {
        try {
            if (!definition.isAbstract() && !this.requiresEagerInit(definition.getFactoryBeanName())) {
                ResolvableType factoryMethodReturnType = this.getFactoryMethodReturnType((BeanDefinition)definition);
                String factoryBeanName = "&" + name;
                if (this.beanFactory.isFactoryBean(factoryBeanName)) {
                    ResolvableType factoryBeanGeneric = this.getFactoryBeanGeneric((ConfigurableListableBeanFactory)this.beanFactory, (BeanDefinition)definition, factoryMethodReturnType);
                    this.beanTypes.put(name, factoryBeanGeneric);
                    this.beanTypes.put(factoryBeanName, this.getType(factoryBeanName, factoryMethodReturnType));
                } else {
                    this.beanTypes.put(name, this.getType(name, factoryMethodReturnType));
                }
            }
            this.beanDefinitions.put(name, definition);
        }
        catch (CannotLoadBeanClassException ex) {
            this.logIgnoredError("bean class loading failure for bean", name, (Exception)((Object)ex));
        }
    }

    private boolean requiresEagerInit(String factoryBeanName) {
        return factoryBeanName != null && this.beanFactory.isFactoryBean(factoryBeanName) && !this.beanFactory.containsSingleton(factoryBeanName);
    }

    private ResolvableType getFactoryMethodReturnType(BeanDefinition definition) {
        try {
            if (StringUtils.hasLength((String)definition.getFactoryBeanName()) && StringUtils.hasLength((String)definition.getFactoryMethodName())) {
                Method method = this.getFactoryMethod((ConfigurableListableBeanFactory)this.beanFactory, definition);
                ResolvableType type = method != null ? ResolvableType.forMethodReturnType((Method)method) : null;
                return type;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Method getFactoryMethod(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws Exception {
        MethodMetadata factoryMethodMetadata;
        if (definition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)definition).getFactoryMethodMetadata()) instanceof StandardMethodMetadata) {
            return ((StandardMethodMetadata)factoryMethodMetadata).getIntrospectedMethod();
        }
        BeanDefinition factoryDefinition = beanFactory.getBeanDefinition(definition.getFactoryBeanName());
        Class factoryClass = ClassUtils.forName((String)factoryDefinition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        return this.getFactoryMethod(definition, factoryClass);
    }

    private Method getFactoryMethod(BeanDefinition definition, Class<?> factoryClass) {
        Method uniqueMethod = null;
        for (Method candidate : this.getCandidateFactoryMethods(definition, factoryClass)) {
            if (!candidate.getName().equals(definition.getFactoryMethodName())) continue;
            if (uniqueMethod == null) {
                uniqueMethod = candidate;
                continue;
            }
            if (this.hasMatchingParameterTypes(candidate, uniqueMethod)) continue;
            return null;
        }
        return uniqueMethod;
    }

    private Method[] getCandidateFactoryMethods(BeanDefinition definition, Class<?> factoryClass) {
        return this.shouldConsiderNonPublicMethods(definition) ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private boolean shouldConsiderNonPublicMethods(BeanDefinition definition) {
        return definition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)definition).isNonPublicAccessAllowed();
    }

    private boolean hasMatchingParameterTypes(Method candidate, Method current) {
        return Arrays.equals(candidate.getParameterTypes(), current.getParameterTypes());
    }

    private void logIgnoredError(String message, String name, Exception ex) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring " + message + " '" + name + "'"), (Throwable)ex);
        }
    }

    private ResolvableType getFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, ResolvableType factoryMethodReturnType) {
        try {
            if (factoryMethodReturnType != null) {
                return this.getFactoryBeanType(definition, factoryMethodReturnType);
            }
            if (StringUtils.hasLength((String)definition.getBeanClassName())) {
                return this.getDirectFactoryBeanGeneric(beanFactory, definition);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ResolvableType getDirectFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws ClassNotFoundException, LinkageError {
        Class factoryBeanClass = ClassUtils.forName((String)definition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        return this.getFactoryBeanType(definition, ResolvableType.forClass((Class)factoryBeanClass));
    }

    private ResolvableType getFactoryBeanType(BeanDefinition definition, ResolvableType type) throws ClassNotFoundException, LinkageError {
        ResolvableType generic = type.as(FactoryBean.class).getGeneric(new int[0]);
        if ((generic == null || generic.resolve().equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = this.getTypeFromAttribute(definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE));
        }
        return generic;
    }

    private ResolvableType getTypeFromAttribute(Object attribute) throws ClassNotFoundException, LinkageError {
        if (attribute instanceof Class) {
            return ResolvableType.forClass((Class)((Class)attribute));
        }
        if (attribute instanceof String) {
            return ResolvableType.forClass((Class)ClassUtils.forName((String)((String)attribute), null));
        }
        return null;
    }

    private ResolvableType getType(String name, ResolvableType factoryMethodReturnType) {
        if (factoryMethodReturnType != null && !factoryMethodReturnType.resolve(Object.class).equals(Object.class)) {
            return factoryMethodReturnType;
        }
        Class type = this.beanFactory.getType(name);
        return type != null ? ResolvableType.forClass((Class)type) : null;
    }

    static BeanTypeRegistry get(ListableBeanFactory beanFactory) {
        Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)beanFactory);
        DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        Assert.isTrue((boolean)listableBeanFactory.isAllowEagerClassLoading(), (String)"Bean factory must allow eager class loading");
        if (!listableBeanFactory.containsLocalBean(BEAN_NAME)) {
            AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(BeanTypeRegistry.class, () -> new BeanTypeRegistry((DefaultListableBeanFactory)beanFactory)).getBeanDefinition();
            listableBeanFactory.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
        }
        return (BeanTypeRegistry)listableBeanFactory.getBean(BEAN_NAME, BeanTypeRegistry.class);
    }

    @FunctionalInterface
    static interface TypeExtractor {
        public Class<?> getBeanType(ResolvableType var1);
    }
}

