/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.Dbcp2JdbcConnectionDetailsBeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.HikariJdbcConnectionDetailsBeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.autoconfigure.jdbc.OracleUcpJdbcConnectionDetailsBeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.PropertiesJdbcConnectionDetails;
import org.springframework.boot.autoconfigure.jdbc.TomcatJdbcConnectionDetailsBeanPostProcessor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

abstract class DataSourceConfiguration {
    DataSourceConfiguration() {
    }

    private static <T> T createDataSource(JdbcConnectionDetails connectionDetails, Class<? extends javax.sql.DataSource> type, ClassLoader classLoader) {
        return (T)DataSourceBuilder.create((ClassLoader)classLoader).type(type).driverClassName(connectionDetails.getDriverClassName()).url(connectionDetails.getJdbcUrl()).username(connectionDetails.getUsername()).password(connectionDetails.getPassword()).build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"})
    static class Generic {
        Generic() {
        }

        @Bean
        javax.sql.DataSource dataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) {
            return (javax.sql.DataSource)DataSourceConfiguration.createDataSource(connectionDetails, properties.getType(), properties.getClassLoader());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={PoolDataSourceImpl.class, OracleConnection.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="oracle.ucp.jdbc.PoolDataSource", matchIfMissing=true)
    static class OracleUcp {
        OracleUcp() {
        }

        @Bean
        static OracleUcpJdbcConnectionDetailsBeanPostProcessor oracleUcpJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
            return new OracleUcpJdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.oracleucp")
        PoolDataSourceImpl dataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) throws SQLException {
            PoolDataSourceImpl dataSource = (PoolDataSourceImpl)DataSourceConfiguration.createDataSource(connectionDetails, PoolDataSourceImpl.class, properties.getClassLoader());
            dataSource.setValidateConnectionOnBorrow(true);
            if (StringUtils.hasText((String)properties.getName())) {
                dataSource.setConnectionPoolName(properties.getName());
            }
            return dataSource;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={BasicDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.commons.dbcp2.BasicDataSource", matchIfMissing=true)
    static class Dbcp2 {
        Dbcp2() {
        }

        @Bean
        static Dbcp2JdbcConnectionDetailsBeanPostProcessor dbcp2JdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
            return new Dbcp2JdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp2")
        BasicDataSource dataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) {
            Class<BasicDataSource> dataSourceType = BasicDataSource.class;
            return (BasicDataSource)DataSourceConfiguration.createDataSource(connectionDetails, dataSourceType, properties.getClassLoader());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
    static class Hikari {
        Hikari() {
        }

        @Bean
        static HikariJdbcConnectionDetailsBeanPostProcessor jdbcConnectionDetailsHikariBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
            return new HikariJdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.hikari")
        HikariDataSource dataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) {
            HikariDataSource dataSource = (HikariDataSource)DataSourceConfiguration.createDataSource(connectionDetails, HikariDataSource.class, properties.getClassLoader());
            if (StringUtils.hasText((String)properties.getName())) {
                dataSource.setPoolName(properties.getName());
            }
            return dataSource;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.tomcat.jdbc.pool.DataSource", matchIfMissing=true)
    static class Tomcat {
        Tomcat() {
        }

        @Bean
        @ConditionalOnMissingBean(value={PropertiesJdbcConnectionDetails.class})
        static TomcatJdbcConnectionDetailsBeanPostProcessor tomcatJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
            return new TomcatJdbcConnectionDetailsBeanPostProcessor(connectionDetailsProvider);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.tomcat")
        DataSource dataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) {
            Class<DataSource> dataSourceType = DataSource.class;
            DataSource dataSource = (DataSource)DataSourceConfiguration.createDataSource(connectionDetails, dataSourceType, properties.getClassLoader());
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl((String)connectionDetails.getJdbcUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }
}

