/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.MongoSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.data.mongo.ReactiveMongoSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.reactive.ReactiveMongoWebSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveMongoOperations.class, ReactiveMongoSessionRepository.class})
@ConditionalOnMissingBean(value={ReactiveSessionRepository.class})
@ConditionalOnBean(value={ReactiveMongoOperations.class})
@EnableConfigurationProperties(value={MongoSessionProperties.class})
@Import(value={ReactiveMongoWebSessionConfiguration.class})
class MongoReactiveSessionConfiguration {
    MongoReactiveSessionConfiguration() {
    }

    @Bean
    ReactiveSessionRepositoryCustomizer<ReactiveMongoSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, MongoSessionProperties mongoSessionProperties, ServerProperties serverProperties) {
        return sessionRepository -> {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getReactive().getSession().getTimeout())).to(arg_0 -> ((ReactiveMongoSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(mongoSessionProperties::getCollectionName).to(arg_0 -> ((ReactiveMongoSessionRepository)sessionRepository).setCollectionName(arg_0));
        };
    }
}

