/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cache.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cache")
public class CacheProperties {
    private @Nullable CacheType type;
    private List<String> cacheNames = new ArrayList<String>();
    private final Caffeine caffeine = new Caffeine();
    private final Couchbase couchbase = new Couchbase();
    private final Infinispan infinispan = new Infinispan();
    private final JCache jcache = new JCache();
    private final Redis redis = new Redis();

    public @Nullable CacheType getType() {
        return this.type;
    }

    public void setType(@Nullable CacheType mode) {
        this.type = mode;
    }

    public List<String> getCacheNames() {
        return this.cacheNames;
    }

    public void setCacheNames(List<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public Caffeine getCaffeine() {
        return this.caffeine;
    }

    public Couchbase getCouchbase() {
        return this.couchbase;
    }

    public Infinispan getInfinispan() {
        return this.infinispan;
    }

    public JCache getJcache() {
        return this.jcache;
    }

    public Redis getRedis() {
        return this.redis;
    }

    public @Nullable Resource resolveConfigLocation(@Nullable Resource config) {
        if (config != null) {
            Assert.isTrue((boolean)config.exists(), () -> "'config' resource [%s] must exist".formatted(config.getDescription()));
            return config;
        }
        return null;
    }

    public static class Caffeine {
        private @Nullable String spec;

        public @Nullable String getSpec() {
            return this.spec;
        }

        public void setSpec(@Nullable String spec) {
            this.spec = spec;
        }
    }

    public static class Couchbase {
        private @Nullable Duration expiration;

        public @Nullable Duration getExpiration() {
            return this.expiration;
        }

        public void setExpiration(@Nullable Duration expiration) {
            this.expiration = expiration;
        }
    }

    public static class Infinispan {
        private @Nullable Resource config;

        public @Nullable Resource getConfig() {
            return this.config;
        }

        public void setConfig(@Nullable Resource config) {
            this.config = config;
        }
    }

    public static class JCache {
        private @Nullable Resource config;
        private @Nullable String provider;

        public @Nullable String getProvider() {
            return this.provider;
        }

        public void setProvider(@Nullable String provider) {
            this.provider = provider;
        }

        public @Nullable Resource getConfig() {
            return this.config;
        }

        public void setConfig(@Nullable Resource config) {
            this.config = config;
        }
    }

    public static class Redis {
        private @Nullable Duration timeToLive;
        private boolean cacheNullValues = true;
        private @Nullable String keyPrefix;
        private boolean useKeyPrefix = true;
        private boolean enableStatistics;

        public @Nullable Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(@Nullable Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public boolean isCacheNullValues() {
            return this.cacheNullValues;
        }

        public void setCacheNullValues(boolean cacheNullValues) {
            this.cacheNullValues = cacheNullValues;
        }

        public @Nullable String getKeyPrefix() {
            return this.keyPrefix;
        }

        public void setKeyPrefix(@Nullable String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public boolean isUseKeyPrefix() {
            return this.useKeyPrefix;
        }

        public void setUseKeyPrefix(boolean useKeyPrefix) {
            this.useKeyPrefix = useKeyPrefix;
        }

        public boolean isEnableStatistics() {
            return this.enableStatistics;
        }

        public void setEnableStatistics(boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
        }
    }
}

