/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.health;

import org.bson.Document;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.util.Assert;

public class MongoHealthIndicator
extends AbstractHealthIndicator {
    private final MongoTemplate mongoTemplate;

    public MongoHealthIndicator(MongoTemplate mongoTemplate) {
        super("MongoDB health check failed");
        Assert.notNull((Object)mongoTemplate, (String)"'mongoTemplate' must not be null");
        this.mongoTemplate = mongoTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Document result = this.mongoTemplate.executeCommand("{ hello: 1 }");
        builder.up().withDetail("maxWireVersion", (Object)result.getInteger((Object)"maxWireVersion"));
    }
}

