/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.rest.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.data.rest.autoconfigure.RepositoryRestProperties;
import org.springframework.core.annotation.Order;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.servlet.config.annotation.CorsRegistry;

@Order(value=0)
class SpringBootRepositoryRestConfigurer
implements RepositoryRestConfigurer {
    private final @Nullable Jackson2ObjectMapperBuilder objectMapperBuilder;
    private final RepositoryRestProperties properties;

    SpringBootRepositoryRestConfigurer(@Nullable Jackson2ObjectMapperBuilder objectMapperBuilder, RepositoryRestProperties properties) {
        this.objectMapperBuilder = objectMapperBuilder;
        this.properties = properties;
    }

    public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
        this.properties.applyTo(config);
    }

    public void configureJacksonObjectMapper(ObjectMapper objectMapper) {
        if (this.objectMapperBuilder != null) {
            this.objectMapperBuilder.configure(objectMapper);
        }
    }
}

