/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.util.Collection;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;
import org.springframework.boot.devtools.remote.server.AccessManager;
import org.springframework.boot.devtools.remote.server.Dispatcher;
import org.springframework.boot.devtools.remote.server.DispatcherFilter;
import org.springframework.boot.devtools.remote.server.HandlerMapper;
import org.springframework.boot.devtools.remote.server.HttpHeaderAccessManager;
import org.springframework.boot.devtools.remote.server.HttpStatusHandler;
import org.springframework.boot.devtools.remote.server.UrlHandlerMapper;
import org.springframework.boot.devtools.restart.server.DefaultSourceFolderUrlFilter;
import org.springframework.boot.devtools.restart.server.HttpRestartServer;
import org.springframework.boot.devtools.restart.server.HttpRestartServerHandler;
import org.springframework.boot.devtools.restart.server.SourceFolderUrlFilter;
import org.springframework.boot.devtools.tunnel.server.HttpTunnelServer;
import org.springframework.boot.devtools.tunnel.server.HttpTunnelServerHandler;
import org.springframework.boot.devtools.tunnel.server.RemoteDebugPortProvider;
import org.springframework.boot.devtools.tunnel.server.SocketTargetServerConnection;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@ConditionalOnProperty(prefix="spring.devtools.remote", name={"secret"})
@ConditionalOnClass(value={Filter.class, ServerHttpRequest.class})
@EnableConfigurationProperties(value={DevToolsProperties.class})
public class RemoteDevToolsAutoConfiguration {
    private static final Log logger = LogFactory.getLog(RemoteDevToolsAutoConfiguration.class);
    @Autowired
    private DevToolsProperties properties;
    @Autowired
    private ServerProperties serverProperties;

    @Bean
    @ConditionalOnMissingBean
    public AccessManager remoteDevToolsAccessManager() {
        RemoteDevToolsProperties remoteProperties = this.properties.getRemote();
        return new HttpHeaderAccessManager(remoteProperties.getSecretHeaderName(), remoteProperties.getSecret());
    }

    @Bean
    public HandlerMapper remoteDevToolsHealthCheckHandlerMapper() {
        HttpStatusHandler handler = new HttpStatusHandler();
        return new UrlHandlerMapper((this.serverProperties.getContextPath() == null ? "" : this.serverProperties.getContextPath()) + this.properties.getRemote().getContextPath(), handler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DispatcherFilter remoteDevToolsDispatcherFilter(AccessManager accessManager, Collection<HandlerMapper> mappers) {
        Dispatcher dispatcher = new Dispatcher(accessManager, mappers);
        return new DispatcherFilter(dispatcher);
    }

    @Configuration
    @ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={ObjectPostProcessor.class})
    static class RemoteDevToolsSecurityConfiguration {
        RemoteDevToolsSecurityConfiguration() {
        }

        @Bean
        public RemoteRestartWebSecurityConfigurer remoteRestartWebSecurityConfigurer() {
            return new RemoteRestartWebSecurityConfigurer();
        }

        @Order(value=-2147483646)
        static class RemoteRestartWebSecurityConfigurer
        extends WebSecurityConfigurerAdapter {
            @Autowired
            private DevToolsProperties properties;

            RemoteRestartWebSecurityConfigurer() {
            }

            public void configure(HttpSecurity http) throws Exception {
                http.antMatcher(this.properties.getRemote().getContextPath() + "/**");
                http.csrf().disable();
            }
        }
    }

    @ConditionalOnProperty(prefix="spring.devtools.remote.debug", name={"enabled"}, matchIfMissing=true)
    static class RemoteDebugTunnelConfiguration {
        @Autowired
        private DevToolsProperties properties;
        @Autowired
        private ServerProperties serverProperties;

        RemoteDebugTunnelConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteDebugHanderMapper"})
        public UrlHandlerMapper remoteDebugHanderMapper(@Qualifier(value="remoteDebugHttpTunnelServer") HttpTunnelServer server) {
            String url = (this.serverProperties.getContextPath() == null ? "" : this.serverProperties.getContextPath()) + this.properties.getRemote().getContextPath() + "/debug";
            logger.warn((Object)("Listening for remote debug traffic on " + url));
            HttpTunnelServerHandler handler = new HttpTunnelServerHandler(server);
            return new UrlHandlerMapper(url, handler);
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteDebugHttpTunnelServer"})
        public HttpTunnelServer remoteDebugHttpTunnelServer() {
            return new HttpTunnelServer(new SocketTargetServerConnection(new RemoteDebugPortProvider()));
        }
    }

    @ConditionalOnProperty(prefix="spring.devtools.remote.restart", name={"enabled"}, matchIfMissing=true)
    static class RemoteRestartConfiguration {
        @Autowired
        private DevToolsProperties properties;
        @Autowired
        private ServerProperties serverProperties;

        RemoteRestartConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SourceFolderUrlFilter remoteRestartSourceFolderUrlFilter() {
            return new DefaultSourceFolderUrlFilter();
        }

        @Bean
        @ConditionalOnMissingBean
        public HttpRestartServer remoteRestartHttpRestartServer(SourceFolderUrlFilter sourceFolderUrlFilter) {
            return new HttpRestartServer(sourceFolderUrlFilter);
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteRestartHanderMapper"})
        public UrlHandlerMapper remoteRestartHanderMapper(HttpRestartServer server) {
            String url = (this.serverProperties.getContextPath() == null ? "" : this.serverProperties.getContextPath()) + this.properties.getRemote().getContextPath() + "/restart";
            logger.warn((Object)("Listening for remote restart updates on " + url));
            HttpRestartServerHandler handler = new HttpRestartServerHandler(server);
            return new UrlHandlerMapper(url, handler);
        }
    }
}

