/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.docker.compose.core.DockerCliCommand;
import org.springframework.boot.docker.compose.core.DockerCliComposeVersionResponse;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.DockerJson;
import org.springframework.boot.docker.compose.core.DockerNotRunningException;
import org.springframework.boot.docker.compose.core.DockerProcessStartException;
import org.springframework.boot.docker.compose.core.ProcessExitException;
import org.springframework.boot.docker.compose.core.ProcessRunner;
import org.springframework.boot.docker.compose.core.ProcessStartException;
import org.springframework.boot.logging.LogLevel;
import org.springframework.core.log.LogMessage;

class DockerCli {
    private static final Map<File, DockerCommands> dockerCommandsCache = new HashMap<File, DockerCommands>();
    private static final Log logger = LogFactory.getLog(DockerCli.class);
    private final ProcessRunner processRunner;
    private final DockerCommands dockerCommands;
    private final DockerComposeFile composeFile;
    private final Set<String> activeProfiles;

    DockerCli(File workingDirectory, DockerComposeFile composeFile, Set<String> activeProfiles) {
        this.processRunner = new ProcessRunner(workingDirectory);
        this.dockerCommands = dockerCommandsCache.computeIfAbsent(workingDirectory, key -> new DockerCommands(this.processRunner));
        this.composeFile = composeFile;
        this.activeProfiles = activeProfiles != null ? activeProfiles : Collections.emptySet();
    }

    <R> R run(DockerCliCommand<R> dockerCommand) {
        List<String> command = this.createCommand(dockerCommand.getType());
        command.addAll(dockerCommand.getCommand());
        Consumer<String> outputConsumer = this.createOutputConsumer(dockerCommand.getLogLevel());
        String json = this.processRunner.run(outputConsumer, command.toArray(new String[0]));
        return dockerCommand.deserialize(json);
    }

    private Consumer<String> createOutputConsumer(LogLevel logLevel) {
        if (logLevel == null || logLevel == LogLevel.OFF) {
            return null;
        }
        return line -> logLevel.log(logger, line);
    }

    private List<String> createCommand(DockerCliCommand.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DockerCliCommand.Type.DOCKER -> new ArrayList<String>(this.dockerCommands.get(type));
            case DockerCliCommand.Type.DOCKER_COMPOSE -> {
                ArrayList<String> result = new ArrayList<String>(this.dockerCommands.get(type));
                if (this.composeFile != null) {
                    result.add("--file");
                    result.add(this.composeFile.toString());
                }
                result.add("--ansi");
                result.add("never");
                for (String profile : this.activeProfiles) {
                    result.add("--profile");
                    result.add(profile);
                }
                yield result;
            }
        };
    }

    DockerComposeFile getDockerComposeFile() {
        return this.composeFile;
    }

    private static class DockerCommands {
        private final List<String> dockerCommand;
        private final List<String> dockerComposeCommand;

        DockerCommands(ProcessRunner processRunner) {
            this.dockerCommand = this.getDockerCommand(processRunner);
            this.dockerComposeCommand = this.getDockerComposeCommand(processRunner);
        }

        private List<String> getDockerCommand(ProcessRunner processRunner) {
            try {
                String version = processRunner.run("docker", "version", "--format", "{{.Client.Version}}");
                logger.trace((Object)LogMessage.format((String)"Using docker %s", (Object)version));
                return List.of("docker");
            }
            catch (ProcessStartException ex) {
                throw new DockerProcessStartException("Unable to start docker process. Is docker correctly installed?", ex);
            }
            catch (ProcessExitException ex) {
                if (ex.getStdErr().contains("docker daemon is not running") || ex.getStdErr().contains("Cannot connect to the Docker daemon")) {
                    throw new DockerNotRunningException(ex.getStdErr(), ex);
                }
                throw ex;
            }
        }

        private List<String> getDockerComposeCommand(ProcessRunner processRunner) {
            try {
                DockerCliComposeVersionResponse response = DockerJson.deserialize(processRunner.run("docker", "compose", "version", "--format", "json"), DockerCliComposeVersionResponse.class);
                logger.trace((Object)LogMessage.format((String)"Using docker compose %s", (Object)response.version()));
                return List.of("docker", "compose");
            }
            catch (ProcessExitException response) {
                try {
                    DockerCliComposeVersionResponse response2 = DockerJson.deserialize(processRunner.run("docker-compose", "version", "--format", "json"), DockerCliComposeVersionResponse.class);
                    logger.trace((Object)LogMessage.format((String)"Using docker-compose %s", (Object)response2.version()));
                    return List.of("docker-compose");
                }
                catch (ProcessStartException ex) {
                    throw new DockerProcessStartException("Unable to start 'docker-compose' process or use 'docker compose'. Is docker correctly installed?", ex);
                }
            }
        }

        List<String> get(DockerCliCommand.Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case DockerCliCommand.Type.DOCKER -> this.dockerCommand;
                case DockerCliCommand.Type.DOCKER_COMPOSE -> this.dockerComposeCommand;
            };
        }
    }
}

