/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.postgres;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PostgresEnvironment {
    private final String username;
    private final String password;
    private final String database;

    PostgresEnvironment(Map<String, String> env) {
        this.username = env.getOrDefault("POSTGRES_USER", "postgres");
        this.password = this.extractPassword(env);
        this.database = env.getOrDefault("POSTGRES_DB", this.username);
    }

    private String extractPassword(Map<String, String> env) {
        String password = env.get("POSTGRES_PASSWORD");
        Assert.state((boolean)StringUtils.hasLength((String)password), (String)"No POSTGRES_PASSWORD defined");
        return password;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

