/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.springframework.util.Assert;

public final class DockerComposeFile {
    private static final List<String> SEARCH_ORDER = List.of("compose.yaml", "compose.yml", "docker-compose.yaml", "docker-compose.yml");
    private final File file;

    private DockerComposeFile(File file) {
        try {
            this.file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerComposeFile other = (DockerComposeFile)obj;
        return this.file.equals(other.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }

    public static DockerComposeFile find(File workingDirectory) {
        File base;
        File file = base = workingDirectory != null ? workingDirectory : new File(".");
        if (!base.exists()) {
            return null;
        }
        Assert.isTrue((boolean)base.isDirectory(), () -> "'%s' is not a directory".formatted(base));
        Path basePath = base.toPath();
        for (String candidate : SEARCH_ORDER) {
            Path resolved = basePath.resolve(candidate);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return DockerComposeFile.of(resolved.toAbsolutePath().toFile());
        }
        return null;
    }

    public static DockerComposeFile of(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        Assert.isTrue((boolean)file.exists(), () -> "Docker Compose file '%s' does not exist".formatted(file));
        Assert.isTrue((boolean)file.isFile(), () -> "Docker compose file '%s' is not a file".formatted(file));
        return new DockerComposeFile(file);
    }
}

