/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.boot.docker.compose.core.DockerCliComposeConfigResponse;
import org.springframework.boot.docker.compose.core.DockerCliComposePsResponse;
import org.springframework.boot.docker.compose.core.DockerCliContextResponse;
import org.springframework.boot.docker.compose.core.DockerCliInspectResponse;
import org.springframework.boot.docker.compose.core.DockerJson;
import org.springframework.boot.logging.LogLevel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class DockerCliCommand<R> {
    private final Type type;
    private final LogLevel logLevel;
    private final Class<?> responseType;
    private final boolean listResponse;
    private final Function<ComposeVersion, List<String>> command;

    private DockerCliCommand(Type type, Class<?> responseType, boolean listResponse, String ... command) {
        this(type, LogLevel.OFF, responseType, listResponse, command);
    }

    private DockerCliCommand(Type type, LogLevel logLevel, Class<?> responseType, boolean listResponse, String ... command) {
        this(type, logLevel, responseType, listResponse, (ComposeVersion version) -> List.of(command));
    }

    private DockerCliCommand(Type type, LogLevel logLevel, Class<?> responseType, boolean listResponse, Function<ComposeVersion, List<String>> command) {
        this.type = type;
        this.logLevel = logLevel;
        this.responseType = responseType;
        this.listResponse = listResponse;
        this.command = command;
    }

    Type getType() {
        return this.type;
    }

    LogLevel getLogLevel() {
        return this.logLevel;
    }

    List<String> getCommand(ComposeVersion composeVersion) {
        return this.command.apply(composeVersion);
    }

    R deserialize(String json) {
        if (this.responseType == Void.class) {
            return null;
        }
        return (R)(!this.listResponse ? DockerJson.deserialize(json, this.responseType) : DockerJson.deserializeToList(json, this.responseType));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerCliCommand other = (DockerCliCommand)obj;
        boolean result = this.type == other.type;
        result = result && this.responseType == other.responseType;
        result = result && this.listResponse == other.listResponse;
        result = result && this.command.apply(ComposeVersion.UNKNOWN).equals(other.command.apply(ComposeVersion.UNKNOWN));
        return result;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.responseType, this.listResponse, this.command});
    }

    public String toString() {
        return "DockerCliCommand [type=%s, responseType=%s, listResponse=%s, command=%s]".formatted(new Object[]{this.type, this.responseType, this.listResponse, this.command});
    }

    protected static String[] join(Collection<String> command, Collection<String> args) {
        ArrayList<String> result = new ArrayList<String>(command);
        result.addAll(args);
        return result.toArray(new String[0]);
    }

    static enum Type {
        DOCKER,
        DOCKER_COMPOSE;

    }

    record ComposeVersion(int major, int minor) {
        public static final ComposeVersion UNKNOWN = new ComposeVersion(0, 0);

        boolean isLessThan(int major, int minor) {
            return this.major() < major || this.major() == major && this.minor() < minor;
        }

        static ComposeVersion of(String value) {
            try {
                value = !value.toLowerCase(Locale.ROOT).startsWith("v") ? value : value.substring(1);
                String[] parts = value.split("\\.");
                return new ComposeVersion(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            }
            catch (Exception ex) {
                return UNKNOWN;
            }
        }
    }

    static final class ComposeStop
    extends DockerCliCommand<Void> {
        ComposeStop(Duration timeout) {
            super(Type.DOCKER_COMPOSE, Void.class, false, "stop", "--timeout", Long.toString(timeout.toSeconds()));
        }
    }

    static final class ComposeStart
    extends DockerCliCommand<Void> {
        ComposeStart(LogLevel logLevel) {
            super(Type.DOCKER_COMPOSE, logLevel, Void.class, false, "start");
        }
    }

    static final class ComposeDown
    extends DockerCliCommand<Void> {
        ComposeDown(Duration timeout) {
            super(Type.DOCKER_COMPOSE, Void.class, false, "down", "--timeout", Long.toString(timeout.toSeconds()));
        }
    }

    static final class ComposeUp
    extends DockerCliCommand<Void> {
        ComposeUp(LogLevel logLevel) {
            super(Type.DOCKER_COMPOSE, logLevel, Void.class, false, "up", "--no-color", "--detach", "--wait");
        }
    }

    static final class ComposePs
    extends DockerCliCommand<List<DockerCliComposePsResponse>> {
        private static final List<String> WITHOUT_ORPHANS = List.of("ps", "--format=json");
        private static final List<String> WITH_ORPHANS = List.of("ps", "--orphans=false", "--format=json");

        ComposePs() {
            super(Type.DOCKER_COMPOSE, LogLevel.OFF, DockerCliComposePsResponse.class, true, ComposePs::getPsCommand);
        }

        private static List<String> getPsCommand(ComposeVersion composeVersion) {
            return composeVersion.isLessThan(2, 24) ? WITHOUT_ORPHANS : WITH_ORPHANS;
        }
    }

    static final class ComposeConfig
    extends DockerCliCommand<DockerCliComposeConfigResponse> {
        ComposeConfig() {
            super(Type.DOCKER_COMPOSE, DockerCliComposeConfigResponse.class, false, "config", "--format=json");
        }
    }

    static final class Inspect
    extends DockerCliCommand<List<DockerCliInspectResponse>> {
        Inspect(Collection<String> ids) {
            super(Type.DOCKER, DockerCliInspectResponse.class, true, Inspect.join(List.of("inspect", "--format={{ json . }}"), ids));
        }
    }

    static final class Context
    extends DockerCliCommand<List<DockerCliContextResponse>> {
        Context() {
            super(Type.DOCKER, DockerCliContextResponse.class, true, "context", "ls", "--format={{ json . }}");
        }
    }
}

