/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.tracing.otlp.Transport;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class OpenTelemetryTracingDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpTracingConnectionDetails> {
    private static final String[] OPENTELEMETRY_IMAGE_NAMES = new String[]{"otel/opentelemetry-collector-contrib", "grafana/otel-lgtm"};
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryTracingDockerComposeConnectionDetailsFactory() {
        super(OPENTELEMETRY_IMAGE_NAMES, "org.springframework.boot.actuate.autoconfigure.tracing.otlp.OtlpTracingAutoConfiguration");
    }

    @Override
    protected OtlpTracingConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryTracingDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryTracingDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpTracingConnectionDetails {
        private final String host;
        private final int grpcPort;
        private final int httPort;

        private OpenTelemetryTracingDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.grpcPort = source.ports().get(4317);
            this.httPort = source.ports().get(4318);
        }

        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> this.httPort;
                case Transport.GRPC -> this.grpcPort;
            };
            return "http://%s:%d/v1/traces".formatted(this.host, port);
        }
    }
}

