/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.clickhouse;

import org.springframework.boot.autoconfigure.jdbc.JdbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.clickhouse.ClickHouseEnvironment;
import org.springframework.boot.docker.compose.service.connection.jdbc.JdbcUrlBuilder;

class ClickHouseJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    private static final String[] CLICKHOUSE_CONTAINER_NAMES = new String[]{"clickhouse/clickhouse-server", "bitnami/clickhouse", "bitnamilegacy/clickhouse"};

    protected ClickHouseJdbcDockerComposeConnectionDetailsFactory() {
        super(CLICKHOUSE_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ClickhouseJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ClickhouseJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("clickhouse", 8123);
        private final ClickHouseEnvironment environment;
        private final String jdbcUrl;

        ClickhouseJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ClickHouseEnvironment(service.env());
            this.jdbcUrl = jdbcUrlBuilder.build(service, this.environment.getDatabase());
        }

        public String getUsername() {
            return this.environment.getUsername();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

