/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.CollectionUtils;

class DockerEnv {
    private final Map<String, String> map;

    DockerEnv(List<String> env) {
        this.map = this.parse(env);
    }

    private Map<String, String> parse(List<String> env) {
        if (CollectionUtils.isEmpty(env)) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        env.stream().map(this::parseEntry).forEach(entry -> result.put(entry.key(), entry.value()));
        return Collections.unmodifiableMap(result);
    }

    private Entry parseEntry(String entry) {
        int index = entry.indexOf(61);
        if (index != -1) {
            String key = entry.substring(0, index);
            String value = entry.substring(index + 1);
            return new Entry(key, value);
        }
        return new Entry(entry, null);
    }

    Map<String, String> asMap() {
        return this.map;
    }

    private record Entry(String key, @Nullable String value) {
    }
}

