/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetails;
import org.springframework.boot.ssl.SslBundle;

public interface ElasticsearchConnectionDetails
extends ConnectionDetails {
    public List<Node> getNodes();

    default public String getUsername() {
        return null;
    }

    default public String getPassword() {
        return null;
    }

    default public String getPathPrefix() {
        return null;
    }

    default public SslBundle getSslBundle() {
        return null;
    }

    public record Node(String hostname, int port, Protocol protocol, String username, String password) {
        public Node(String host, int port, Protocol protocol) {
            this(host, port, protocol, null, null);
        }

        URI toUri() {
            try {
                return new URI(this.protocol.getScheme(), this.userInfo(), this.hostname, this.port, null, null, null);
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("Can't construct URI", ex);
            }
        }

        private String userInfo() {
            if (this.username == null) {
                return null;
            }
            return this.password != null ? this.username + ":" + this.password : this.username;
        }

        public static enum Protocol {
            HTTP("http"),
            HTTPS("https");

            private final String scheme;

            private Protocol(String scheme) {
                this.scheme = scheme;
            }

            String getScheme() {
                return this.scheme;
            }

            static Protocol forScheme(String scheme) {
                for (Protocol protocol : Protocol.values()) {
                    if (!protocol.scheme.equals(scheme)) continue;
                    return protocol;
                }
                throw new IllegalArgumentException("Unknown scheme '" + scheme + "'");
            }
        }
    }
}

