/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.JavaExec;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.SpringBootResolutionStrategy;
import org.springframework.boot.gradle.task.ComputeMain;
import org.springframework.boot.gradle.task.Repackage;
import org.springframework.boot.gradle.task.RunApp;
import org.springframework.boot.gradle.task.RunWithAgent;

public class SpringBootPlugin
implements Plugin<Project> {
    private static final String REPACKAGE_TASK_NAME = "bootRepackage";
    private static final String RUN_APP_TASK_NAME = "bootRun";

    public void apply(Project project) {
        this.applyRepackage(project);
        this.applyRun(project);
        project.getPlugins().apply(BasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        project.getExtensions().create("springBoot", SpringBootPluginExtension.class, new Object[0]);
        this.applyResolutionStrategy(project);
    }

    private void applyRepackage(Project project) {
        Repackage packageTask = this.addRepackageTask(project);
        this.ensureTaskRunsOnAssembly(project, packageTask);
        project.getExtensions().getExtraProperties().set("BootRepackage", Repackage.class);
    }

    private void applyRun(Project project) {
        this.enhanceRunTask(project);
        this.addRunAppTask(project);
        if (project.getTasks().withType(JavaExec.class).isEmpty()) {
            project.getPlugins().apply(ApplicationPlugin.class);
        }
    }

    private void enhanceRunTask(Project project) {
        project.getLogger().debug("Enhancing run tasks");
        project.getTasks().whenTaskAdded((Action)new RunWithAgent(project));
        project.getTasks().whenTaskAdded((Action)new ComputeMain(project));
    }

    private void applyResolutionStrategy(Project project) {
        project.getConfigurations().all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                SpringBootResolutionStrategy.apply(configuration.getResolutionStrategy());
            }
        });
    }

    private Repackage addRepackageTask(Project project) {
        Repackage packageTask = (Repackage)project.getTasks().create(REPACKAGE_TASK_NAME, Repackage.class);
        packageTask.setDescription("Repackage existing JAR and WAR archives so that they can be executed from the command line using 'java -jar'");
        packageTask.setGroup("build");
        packageTask.dependsOn(new Object[]{project.getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies()});
        return packageTask;
    }

    private void addRunAppTask(Project project) {
        RunApp runJarTask = (RunApp)project.getTasks().create(RUN_APP_TASK_NAME, RunApp.class);
        runJarTask.setDescription("Run the project with support for auto-detecting main class and reloading static resources");
        runJarTask.setGroup("Execution");
        if (!project.getTasksByName("compileJava", false).isEmpty()) {
            if (!project.getTasksByName("compileGroovy", false).isEmpty()) {
                runJarTask.dependsOn(new Object[]{"compileJava", "compileGroovy"});
            } else {
                runJarTask.dependsOn(new Object[]{"compileJava"});
            }
        }
    }

    private void ensureTaskRunsOnAssembly(Project project, Repackage task) {
        project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
    }
}

