/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.task;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.springframework.boot.loader.tools.MainClassFinder;

public class ComputeMain
implements Action<Task> {
    private Project project;

    public ComputeMain(Project project) {
        this.project = project;
    }

    public void execute(Task task) {
        if (task instanceof JavaExec) {
            final JavaExec exec = (JavaExec)task;
            this.project.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    ComputeMain.this.addMain(exec);
                }
            });
        }
    }

    private void addMain(JavaExec exec) {
        if (exec.getMain() == null) {
            this.project.getLogger().debug("Computing main for: " + exec);
            this.project.setProperty("mainClassName", (Object)this.findMainClass(this.project));
        }
    }

    private String findMainClass(Project project) {
        SourceSet main = ComputeMain.findMainSourceSet(project);
        if (main == null) {
            return null;
        }
        project.getLogger().debug("Looking for main in: " + main.getOutput().getClassesDir());
        try {
            String mainClass = MainClassFinder.findMainClass((File)main.getOutput().getClassesDir());
            project.getLogger().info("Computed main class: " + mainClass);
            return mainClass;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot find main class", ex);
        }
    }

    public static SourceSet findMainSourceSet(Project project) {
        final AtomicReference main = new AtomicReference();
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        javaConvention.getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(SourceSet set) {
                if ("main".equals(set.getName())) {
                    main.set(set);
                }
            }
        });
        return (SourceSet)main.get();
    }
}

