/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.task;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;

class ProjectLibraries
implements Libraries {
    private final Project project;
    private String providedConfigurationName = "providedRuntime";
    private String customConfigurationName = null;

    public ProjectLibraries(Project project) {
        this.project = project;
    }

    public void setProvidedConfigurationName(String providedConfigurationName) {
        this.providedConfigurationName = providedConfigurationName;
    }

    public void setCustomConfigurationName(String customConfigurationName) {
        this.customConfigurationName = customConfigurationName;
    }

    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Configuration custom;
        Configuration configuration = custom = this.customConfigurationName != null ? (Configuration)this.project.getConfigurations().findByName(this.customConfigurationName) : null;
        if (custom != null) {
            this.libraries(LibraryScope.CUSTOM, this.getResolvedArtifacts(custom), callback);
        } else {
            Set<ResolvedArtifact> compileArtifacts = this.getResolvedArtifacts("compile");
            Set<ResolvedArtifact> runtimeArtifacts = this.getResolvedArtifacts("runtime");
            runtimeArtifacts.removeAll(compileArtifacts);
            Set<ResolvedArtifact> providedArtifacts = this.getResolvedArtifacts(this.providedConfigurationName);
            compileArtifacts.removeAll(providedArtifacts);
            runtimeArtifacts.removeAll(providedArtifacts);
            this.libraries(LibraryScope.COMPILE, compileArtifacts, callback);
            this.libraries(LibraryScope.RUNTIME, runtimeArtifacts, callback);
            this.libraries(LibraryScope.PROVIDED, providedArtifacts, callback);
        }
    }

    private Set<ResolvedArtifact> getResolvedArtifacts(Configuration configuration) {
        if (configuration == null) {
            return Collections.emptySet();
        }
        return configuration.getResolvedConfiguration().getResolvedArtifacts();
    }

    private Set<ResolvedArtifact> getResolvedArtifacts(String configurationName) {
        Configuration configuration = (Configuration)this.project.getConfigurations().findByName(configurationName);
        return this.getResolvedArtifacts(configuration);
    }

    private void libraries(LibraryScope scope, Set<ResolvedArtifact> artifacts, LibraryCallback callback) throws IOException {
        for (ResolvedArtifact artifact : artifacts) {
            callback.library(artifact.getFile(), scope);
        }
    }
}

