/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.task;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.task.ProjectLibraries;
import org.springframework.boot.loader.tools.Repackager;

public class Repackage
extends DefaultTask {
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private String customConfiguration;
    private Object withJarTask;
    private String mainClass;

    public void setCustomConfiguration(String customConfiguration) {
        this.customConfiguration = customConfiguration;
    }

    public void setWithJarTask(Object withJarTask) {
        this.withJarTask = withJarTask;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @TaskAction
    public void repackage() {
        Project project = this.getProject();
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        ProjectLibraries libraries = new ProjectLibraries(project);
        if (extension.getProvidedConfiguration() != null) {
            libraries.setProvidedConfigurationName(extension.getProvidedConfiguration());
        }
        if (this.customConfiguration != null) {
            libraries.setCustomConfigurationName(this.customConfiguration);
        } else if (extension.getCustomConfiguration() != null) {
            libraries.setCustomConfigurationName(extension.getCustomConfiguration());
        }
        JavaExec runner = (JavaExec)project.getTasks().findByName("run");
        if (runner != null && this.mainClass == null) {
            this.getLogger().info("Found main in run task: " + runner.getMain());
            this.setMainClass(runner.getMain());
        }
        project.getTasks().withType(Jar.class, (Action)new RepackageAction(extension, libraries));
    }

    private class LoggingRepackager
    extends Repackager {
        public LoggingRepackager(File source) {
            super(source);
        }

        protected String findMainMethod(JarFile source) throws IOException {
            long startTime = System.currentTimeMillis();
            try {
                String string = super.findMainMethod(source);
                return string;
            }
            finally {
                long duration = System.currentTimeMillis() - startTime;
                if (duration > FIND_WARNING_TIMEOUT) {
                    Repackage.this.getLogger().warn("Searching for the main-class is taking some time, consider using setting 'springBoot.mainClass'");
                }
            }
        }
    }

    private class RepackageAction
    implements Action<Jar> {
        private final SpringBootPluginExtension extension;
        private final ProjectLibraries libraries;

        public RepackageAction(SpringBootPluginExtension extension, ProjectLibraries libraries) {
            this.extension = extension;
            this.libraries = libraries;
        }

        public void execute(Jar archive) {
            File file;
            if (Repackage.this.withJarTask != null && !archive.equals(Repackage.this.withJarTask)) {
                return;
            }
            if ("".equals(archive.getClassifier()) && (file = archive.getArchivePath()).exists()) {
                LoggingRepackager repackager = new LoggingRepackager(file);
                repackager.setMainClass(this.extension.getMainClass());
                if (Repackage.this.mainClass != null) {
                    repackager.setMainClass(Repackage.this.mainClass);
                }
                if (this.extension.convertLayout() != null) {
                    repackager.setLayout(this.extension.convertLayout());
                }
                repackager.setBackupSource(this.extension.isBackupSource());
                try {
                    repackager.repackage(this.libraries);
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex.getMessage(), ex);
                }
            }
        }
    }
}

