/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.springframework.boot.gradle.task.ComputeMain;
import org.springframework.boot.loader.tools.MainClassFinder;

public class RunApp
extends DefaultTask {
    @TaskAction
    public void runApp() {
        Project project = this.getProject();
        final SourceSet main = ComputeMain.findMainSourceSet(project);
        final File outputDir = main == null ? null : main.getOutput().getResourcesDir();
        final LinkedHashSet allResources = new LinkedHashSet();
        if (main != null) {
            allResources.addAll(main.getResources().getSrcDirs());
        }
        project.getTasks().withType(JavaExec.class, (Action)new Action<JavaExec>(){

            public void execute(JavaExec exec) {
                ArrayList files = new ArrayList(exec.getClasspath().getFiles());
                files.addAll(0, allResources);
                RunApp.this.getLogger().info("Adding classpath: " + allResources);
                exec.setClasspath((FileCollection)new SimpleFileCollection(files));
                if (exec.getMain() == null) {
                    final String mainClass = RunApp.this.findMainClass(main);
                    exec.setMain(mainClass);
                    exec.getConventionMapping().map("main", (Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return mainClass;
                        }
                    });
                    RunApp.this.getLogger().info("Found main: " + mainClass);
                }
                if (outputDir != null) {
                    for (File directory : allResources) {
                        this.removeDuplicatesFromOutputDir(directory, outputDir);
                    }
                }
                exec.exec();
            }

            private void removeDuplicatesFromOutputDir(File directory, File outputDir2) {
                if (directory.isDirectory()) {
                    String[] stringArray = directory.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        File outputFile = new File(outputDir2, name);
                        if (outputFile.exists() && outputFile.canWrite()) {
                            RunApp.this.getProject().delete(new Object[]{outputFile});
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private String findMainClass(SourceSet main) {
        if (main == null) {
            return null;
        }
        this.getLogger().info("Looking for main in: " + main.getOutput().getClassesDir());
        try {
            return MainClassFinder.findMainClass((File)main.getOutput().getClassesDir());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot find main class", ex);
        }
    }
}

