/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.task;

import java.io.File;
import java.security.CodeSource;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.JavaExec;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.task.RunApp;
import org.springframework.boot.loader.tools.AgentAttacher;
import org.springframework.core.task.TaskRejectedException;

public class RunWithAgent
implements Action<Task> {
    private static final String SPRING_LOADED_AGENT_CLASSNAME = "org.springsource.loaded.agent.SpringLoadedAgent";
    private File agent;
    private Project project;
    private Boolean noverify;

    public RunWithAgent(Project project) {
        this.project = project;
    }

    public void execute(final Task task) {
        if (task instanceof JavaExec) {
            this.project.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    RunWithAgent.this.addAgent((JavaExec)task);
                }
            });
        }
        if (task instanceof RunApp) {
            this.project.beforeEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    RunWithAgent.this.addAgent((RunApp)task);
                }
            });
        }
    }

    private void addAgent(RunApp exec) {
        this.project.getLogger().debug("Attaching to: " + (Object)((Object)exec));
        this.findAgent((SpringBootPluginExtension)this.project.getExtensions().getByType(SpringBootPluginExtension.class));
        if (this.agent != null) {
            exec.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    RunWithAgent.this.project.getLogger().info("Attaching agent: " + RunWithAgent.this.agent);
                    if (RunWithAgent.this.noverify != null && RunWithAgent.this.noverify.booleanValue() && !AgentAttacher.hasNoVerify()) {
                        throw new TaskRejectedException("The JVM must be started with -noverify for this agent to work. You can use JAVA_OPTS to add that flag.");
                    }
                    AgentAttacher.attach((File)RunWithAgent.this.agent);
                }
            });
        }
    }

    private void addAgent(JavaExec exec) {
        this.project.getLogger().debug("Attaching to: " + exec);
        this.findAgent((SpringBootPluginExtension)this.project.getExtensions().getByType(SpringBootPluginExtension.class));
        if (this.agent != null) {
            this.project.getLogger().info("Attaching agent: " + this.agent);
            exec.jvmArgs(new Object[]{"-javaagent:" + this.agent.getAbsolutePath()});
            if (this.noverify != null && this.noverify.booleanValue()) {
                exec.jvmArgs(new Object[]{"-noverify"});
            }
        }
    }

    private void findAgent(SpringBootPluginExtension extension) {
        if (this.agent != null) {
            return;
        }
        this.noverify = ((SpringBootPluginExtension)this.project.getExtensions().getByType(SpringBootPluginExtension.class)).getNoverify();
        this.project.getLogger().info("Finding agent");
        if (this.project.hasProperty("run.agent")) {
            this.agent = this.project.file(this.project.property("run.agent"));
        } else if (extension.getAgent() != null) {
            this.agent = extension.getAgent();
        }
        if (this.agent == null) {
            try {
                Class<?> loaded = Class.forName(SPRING_LOADED_AGENT_CLASSNAME);
                if (this.agent == null && loaded != null) {
                    CodeSource source;
                    if (this.noverify == null) {
                        this.noverify = true;
                    }
                    if ((source = loaded.getProtectionDomain().getCodeSource()) != null) {
                        this.agent = new File(source.getLocation().getFile());
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.project.getLogger().debug("Agent: " + this.agent);
    }
}

