/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.buildinfo;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.loader.tools.BuildPropertiesWriter;

public class BuildInfo
extends DefaultTask {
    @OutputFile
    private File outputFile = this.getProject().file((Object)new File(this.getProject().getBuildDir(), "resources/main/META-INF/build-info.properties"));
    @Input
    private String projectGroup = this.getProject().getGroup().toString();
    @Input
    private String projectArtifact = ((Jar)this.getProject().getTasks().getByName("jar")).getBaseName();
    @Input
    private String projectVersion = this.getProject().getVersion().toString();
    @Input
    private String projectName = this.getProject().getName();
    @Input
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @TaskAction
    public void generateBuildProperties() {
        try {
            new BuildPropertiesWriter(this.outputFile).writeBuildProperties(new BuildPropertiesWriter.ProjectDetails(this.projectGroup, this.projectArtifact, this.projectVersion, this.projectName, this.coerceToStringValues(this.additionalProperties)));
        }
        catch (IOException ex) {
            throw new TaskExecutionException((Task)this, (Throwable)ex);
        }
    }

    public String getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(String projectGroup) {
        this.projectGroup = projectGroup;
    }

    public String getProjectArtifact() {
        return this.projectArtifact;
    }

    public void setProjectArtifact(String projectArtifact) {
        this.projectArtifact = projectArtifact;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    private Map<String, String> coerceToStringValues(Map<String, Object> input) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            output.put(entry.getKey(), entry.getValue().toString());
        }
        return output;
    }
}

