/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.run;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;

public class BootRun
extends JavaExec {
    private boolean optimizedLaunch = true;

    @Input
    public boolean isOptimizedLaunch() {
        return this.optimizedLaunch;
    }

    public void setOptimizedLaunch(boolean optimizedLaunch) {
        this.optimizedLaunch = optimizedLaunch;
    }

    public void sourceResources(SourceSet sourceSet) {
        File resourcesDir = sourceSet.getOutput().getResourcesDir();
        Set srcDirs = sourceSet.getResources().getSrcDirs();
        this.setClasspath(this.getProject().files(new Object[]{srcDirs, this.getClasspath()}).filter(file -> !file.equals(resourcesDir)));
    }

    public void exec() {
        if (this.optimizedLaunch) {
            this.setJvmArgs(this.getJvmArgs());
            if (!this.isJava13OrLater()) {
                this.jvmArgs(new Object[]{"-Xverify:none"});
            }
            this.jvmArgs(new Object[]{"-XX:TieredStopAtLevel=1"});
        }
        if (System.console() != null) {
            this.getEnvironment().put("spring.output.ansi.console-available", true);
        }
        super.exec();
    }

    private boolean isJava13OrLater() {
        for (Method method : String.class.getMethods()) {
            if (!method.getName().equals("stripIndent")) continue;
            return true;
        }
        return false;
    }
}

