/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.springframework.boot.gradle.plugin.ResolveMainClassName;
import org.springframework.boot.gradle.plugin.SpringBootPlugin;
import org.springframework.boot.gradle.tasks.aot.AbstractAot;
import org.springframework.boot.gradle.tasks.aot.ProcessAot;
import org.springframework.boot.gradle.tasks.aot.ProcessTestAot;

public class SpringBootAotPlugin
implements Plugin<Project> {
    public static final String AOT_SOURCE_SET_NAME = "aot";
    public static final String AOT_TEST_SOURCE_SET_NAME = "aotTest";
    public static final String PROCESS_AOT_TASK_NAME = "processAot";
    public static final String PROCESS_TEST_AOT_TASK_NAME = "processTestAot";

    public void apply(Project project) {
        PluginContainer plugins = project.getPlugins();
        plugins.withType(JavaPlugin.class).all(javaPlugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSetContainer sourceSets = javaPluginExtension.getSourceSets();
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet aotSourceSet = this.configureSourceSet(project, AOT_SOURCE_SET_NAME, mainSourceSet);
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            SourceSet aotTestSourceSet = this.configureSourceSet(project, AOT_TEST_SOURCE_SET_NAME, testSourceSet);
            plugins.withType(SpringBootPlugin.class).all(bootPlugin -> {
                this.registerProcessAotTask(project, aotSourceSet, mainSourceSet);
                this.registerProcessTestAotTask(project, mainSourceSet, aotTestSourceSet, testSourceSet);
            });
        });
    }

    private SourceSet configureSourceSet(Project project, String newSourceSetName, SourceSet existingSourceSet) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSetContainer sourceSets = javaPluginExtension.getSourceSets();
        return (SourceSet)sourceSets.create(newSourceSetName, sourceSet -> {
            existingSourceSet.setRuntimeClasspath(existingSourceSet.getRuntimeClasspath().plus((FileCollection)sourceSet.getOutput()));
            project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()).attributes(attributes -> {
                this.configureClassesAndResourcesLibraryElementsAttribute(project, (AttributeContainer)attributes);
                this.configureJavaRuntimeUsageAttribute(project, (AttributeContainer)attributes);
            });
        });
    }

    private void configureClassesAndResourcesLibraryElementsAttribute(Project project, AttributeContainer attributes) {
        LibraryElements classesAndResources = (LibraryElements)project.getObjects().named(LibraryElements.class, "classes+resources");
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)classesAndResources);
    }

    private void configureJavaRuntimeUsageAttribute(Project project, AttributeContainer attributes) {
        Usage javaRuntime = (Usage)project.getObjects().named(Usage.class, "java-runtime");
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)javaRuntime);
    }

    private void registerProcessAotTask(Project project, SourceSet aotSourceSet, SourceSet mainSourceSet) {
        TaskProvider resolveMainClassName = project.getTasks().named("resolveMainClassName", ResolveMainClassName.class);
        Configuration aotClasspath = this.createAotProcessingClasspath(project, PROCESS_AOT_TASK_NAME, mainSourceSet);
        project.getDependencies().add(aotClasspath.getName(), (Object)project.files(new Object[]{mainSourceSet.getOutput()}));
        Configuration compileClasspath = project.getConfigurations().getByName(aotSourceSet.getCompileClasspathConfigurationName());
        compileClasspath.extendsFrom(new Configuration[]{aotClasspath});
        Provider resourcesOutput = project.getLayout().getBuildDirectory().dir("generated/" + aotSourceSet.getName() + "Resources");
        TaskProvider processAot = project.getTasks().register(PROCESS_AOT_TASK_NAME, ProcessAot.class, task -> {
            this.configureAotTask(project, aotSourceSet, (AbstractAot)((Object)task), mainSourceSet, (Provider<Directory>)resourcesOutput);
            task.getApplicationMainClass().set(resolveMainClassName.flatMap(ResolveMainClassName::readMainClassName));
            task.setClasspath((FileCollection)aotClasspath);
        });
        aotSourceSet.getJava().srcDir((Object)processAot.map(AbstractAot::getSourcesOutput));
        aotSourceSet.getResources().srcDir((Object)resourcesOutput);
        ConfigurableFileCollection classesOutputFiles = project.files(new Object[]{processAot.map(AbstractAot::getClassesOutput)});
        mainSourceSet.setRuntimeClasspath(mainSourceSet.getRuntimeClasspath().plus((FileCollection)classesOutputFiles));
        project.getDependencies().add(aotSourceSet.getImplementationConfigurationName(), (Object)classesOutputFiles);
        this.configureDependsOn(project, aotSourceSet, (TaskProvider<? extends AbstractAot>)processAot);
    }

    private void configureAotTask(Project project, SourceSet sourceSet, AbstractAot task, SourceSet inputSourceSet, Provider<Directory> resourcesOutput) {
        task.getSourcesOutput().set(project.getLayout().getBuildDirectory().dir("generated/" + sourceSet.getName() + "Sources"));
        task.getResourcesOutput().set(resourcesOutput);
        task.getClassesOutput().set(project.getLayout().getBuildDirectory().dir("generated/" + sourceSet.getName() + "Classes"));
        task.getGroupId().set(project.provider(() -> String.valueOf(project.getGroup())));
        task.getArtifactId().set(project.provider(() -> project.getName()));
        this.configureToolchainConvention(project, task);
    }

    private void configureToolchainConvention(Project project, AbstractAot aotTask) {
        JavaToolchainSpec toolchain = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
        JavaToolchainService toolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        aotTask.getJavaLauncher().convention(toolchainService.launcherFor(toolchain));
    }

    private Configuration createAotProcessingClasspath(Project project, String taskName, SourceSet inputSourceSet) {
        Configuration base = project.getConfigurations().getByName(inputSourceSet.getRuntimeClasspathConfigurationName());
        Configuration aotClasspath = (Configuration)project.getConfigurations().create(taskName + "Classpath", classpath -> {
            classpath.setCanBeConsumed(false);
            if (!classpath.isCanBeResolved()) {
                throw new IllegalStateException("Unexpected");
            }
            classpath.setCanBeResolved(true);
            classpath.setDescription("Classpath of the " + taskName + " task.");
            this.removeDevelopmentOnly(base.getExtendsFrom()).forEach(xva$0 -> classpath.extendsFrom(new Configuration[]{xva$0}));
            classpath.attributes(attributes -> {
                ProviderFactory providers = project.getProviders();
                AttributeContainer baseAttributes = base.getAttributes();
                for (Attribute attribute : baseAttributes.keySet()) {
                    attributes.attributeProvider(attribute, providers.provider(() -> baseAttributes.getAttribute(attribute)));
                }
            });
        });
        return aotClasspath;
    }

    private Stream<Configuration> removeDevelopmentOnly(Set<Configuration> configurations) {
        return configurations.stream().filter(this::isNotDevelopmentOnly);
    }

    private boolean isNotDevelopmentOnly(Configuration configuration) {
        return !"developmentOnly".equals(configuration.getName());
    }

    private void configureDependsOn(Project project, SourceSet aotSourceSet, TaskProvider<? extends AbstractAot> processAot) {
        project.getTasks().named(aotSourceSet.getProcessResourcesTaskName()).configure(processResources -> processResources.dependsOn(new Object[]{processAot}));
    }

    private void registerProcessTestAotTask(Project project, SourceSet mainSourceSet, SourceSet aotTestSourceSet, SourceSet testSourceSet) {
        Configuration aotClasspath = this.createAotProcessingClasspath(project, PROCESS_TEST_AOT_TASK_NAME, testSourceSet);
        this.addJUnitPlatformLauncherDependency(project, aotClasspath);
        Configuration compileClasspath = project.getConfigurations().getByName(aotTestSourceSet.getCompileClasspathConfigurationName());
        compileClasspath.extendsFrom(new Configuration[]{aotClasspath});
        Provider resourcesOutput = project.getLayout().getBuildDirectory().dir("generated/" + aotTestSourceSet.getName() + "Resources");
        TaskProvider processTestAot = project.getTasks().register(PROCESS_TEST_AOT_TASK_NAME, ProcessTestAot.class, task -> {
            this.configureAotTask(project, aotTestSourceSet, (AbstractAot)((Object)task), testSourceSet, (Provider<Directory>)resourcesOutput);
            task.setClasspath((FileCollection)aotClasspath);
            task.setClasspathRoots((FileCollection)testSourceSet.getOutput());
        });
        aotTestSourceSet.getJava().srcDir((Object)processTestAot.map(AbstractAot::getSourcesOutput));
        aotTestSourceSet.getResources().srcDir((Object)resourcesOutput);
        project.getDependencies().add(aotClasspath.getName(), (Object)project.files(new Object[]{mainSourceSet.getOutput()}));
        project.getDependencies().add(aotClasspath.getName(), (Object)project.files(new Object[]{testSourceSet.getOutput()}));
        ConfigurableFileCollection classesOutputFiles = project.files(new Object[]{processTestAot.map(AbstractAot::getClassesOutput)});
        testSourceSet.setRuntimeClasspath(testSourceSet.getRuntimeClasspath().plus((FileCollection)classesOutputFiles));
        project.getDependencies().add(aotTestSourceSet.getImplementationConfigurationName(), (Object)classesOutputFiles);
        this.configureDependsOn(project, aotTestSourceSet, (TaskProvider<? extends AbstractAot>)processTestAot);
    }

    private void addJUnitPlatformLauncherDependency(Project project, Configuration configuration) {
        DependencyHandler dependencyHandler = project.getDependencies();
        Dependency springBootDependencies = dependencyHandler.create((Object)dependencyHandler.platform((Object)SpringBootPlugin.BOM_COORDINATES));
        DependencySet dependencies = configuration.getDependencies();
        dependencies.add((Object)springBootDependencies);
        dependencies.add((Object)dependencyHandler.create((Object)"org.junit.platform:junit-platform-launcher"));
    }
}

