/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.contributor;

import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.util.Assert;

abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Function<B, I> indicatorFactory;

    protected AbstractCompositeHealthContributorConfiguration(Function<B, I> indicatorFactory) {
        this.indicatorFactory = indicatorFactory;
    }

    protected final C createContributor(ConfigurableListableBeanFactory beanFactory, Class<B> beanType) {
        return this.createContributor(SimpleAutowireCandidateResolver.resolveAutowireCandidates((ConfigurableListableBeanFactory)beanFactory, beanType));
    }

    protected final C createContributor(Map<String, B> beans) {
        Assert.notEmpty(beans, (String)"'beans' must not be empty");
        if (beans.size() == 1) {
            return (C)this.createIndicator(beans.values().iterator().next());
        }
        return this.createComposite(beans);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean) {
        return this.indicatorFactory.apply(bean);
    }
}

