/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.registry;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.registry.HealthContributorNameGenerator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.registry.DefaultHealthContributorRegistry;
import org.springframework.boot.health.registry.DefaultReactiveHealthContributorRegistry;
import org.springframework.boot.health.registry.HealthContributorNameValidator;
import org.springframework.boot.health.registry.HealthContributorRegistry;
import org.springframework.boot.health.registry.ReactiveHealthContributorRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@AutoConfiguration
public final class HealthContributorRegistryAutoConfiguration {
    HealthContributorRegistryAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthContributorRegistry.class})
    DefaultHealthContributorRegistry healthContributorRegistry(Map<String, HealthContributor> contributorBeans, ObjectProvider<HealthContributorNameGenerator> nameGeneratorProvider, List<HealthContributorNameValidator> nameValidators) {
        HealthContributorNameGenerator nameGenerator = (HealthContributorNameGenerator)nameGeneratorProvider.getIfAvailable(HealthContributorNameGenerator::withoutStandardSuffixes);
        return new DefaultHealthContributorRegistry(nameValidators, nameGenerator.registrar(contributorBeans));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Flux.class})
    static class ReactiveHealthContributorRegistryConfiguration {
        ReactiveHealthContributorRegistryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ReactiveHealthContributorRegistry.class})
        DefaultReactiveHealthContributorRegistry reactiveHealthContributorRegistry(Map<String, ReactiveHealthContributor> contributorBeans, ObjectProvider<HealthContributorNameGenerator> nameGeneratorProvider, List<HealthContributorNameValidator> nameValidators) {
            HealthContributorNameGenerator nameGenerator = (HealthContributorNameGenerator)nameGeneratorProvider.getIfAvailable(HealthContributorNameGenerator::withoutStandardSuffixes);
            return new DefaultReactiveHealthContributorRegistry(nameValidators, nameGenerator.registrar(contributorBeans));
        }
    }
}

