/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure.reactive;

import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;

public abstract class AbstractClientHttpConnectorProperties {
    private HttpRedirects redirects;
    private Duration connectTimeout;
    private Duration readTimeout;
    private final Ssl ssl = new Ssl();
    private Connector connector;

    public HttpRedirects getRedirects() {
        return this.redirects;
    }

    public void setRedirects(HttpRedirects redirects) {
        this.redirects = redirects;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public static class Ssl {
        private String bundle;

        public String getBundle() {
            return this.bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }
    }

    public static enum Connector {
        REACTOR(ClientHttpConnectorBuilder::reactor),
        JETTY(ClientHttpConnectorBuilder::jetty),
        HTTP_COMPONENTS(ClientHttpConnectorBuilder::httpComponents),
        JDK(ClientHttpConnectorBuilder::jdk);

        private final Supplier<ClientHttpConnectorBuilder<?>> builderSupplier;

        private Connector(Supplier<ClientHttpConnectorBuilder<?>> builderSupplier) {
            this.builderSupplier = builderSupplier;
        }

        ClientHttpConnectorBuilder<?> builder() {
            return this.builderSupplier.get();
        }
    }
}

