/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.autoconfigure;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.http.client.autoconfigure.AbstractHttpRequestFactoryProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

public final class ClientHttpRequestFactories {
    private final ObjectFactory<SslBundles> sslBundles;
    private final @Nullable AbstractHttpRequestFactoryProperties[] orderedProperties;
    private final @Nullable ClientHttpRequestFactoryBuilder<?> fallbackBuilder;
    private final @Nullable ClientHttpRequestFactorySettings fallbackSettings;

    public ClientHttpRequestFactories(ObjectFactory<SslBundles> sslBundles, AbstractHttpRequestFactoryProperties ... orderedProperties) {
        this(null, null, sslBundles, orderedProperties);
    }

    public ClientHttpRequestFactories(@Nullable ClientHttpRequestFactoryBuilder<?> fallbackBuilder, @Nullable ClientHttpRequestFactorySettings fallbackSettings, ObjectFactory<SslBundles> sslBundles, AbstractHttpRequestFactoryProperties ... orderedProperties) {
        this.fallbackBuilder = fallbackBuilder;
        this.fallbackSettings = fallbackSettings;
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    public ClientHttpRequestFactoryBuilder<?> builder(@Nullable ClassLoader classLoader) {
        AbstractHttpRequestFactoryProperties.Factory factory = this.getProperty(AbstractHttpRequestFactoryProperties::getFactory, Objects::nonNull, null, Function.identity());
        if (factory != null) {
            return factory.builder();
        }
        return this.fallbackBuilder != null ? this.fallbackBuilder : ClientHttpRequestFactoryBuilder.detect(classLoader);
    }

    public ClientHttpRequestFactorySettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractHttpRequestFactoryProperties::getRedirects, Objects::nonNull, this.fallbackSettings, ClientHttpRequestFactorySettings::redirects);
        Duration connectTimeout = this.getProperty(AbstractHttpRequestFactoryProperties::getConnectTimeout, Objects::nonNull, this.fallbackSettings, ClientHttpRequestFactorySettings::connectTimeout);
        Duration readTimeout = this.getProperty(AbstractHttpRequestFactoryProperties::getReadTimeout, Objects::nonNull, this.fallbackSettings, ClientHttpRequestFactorySettings::readTimeout);
        String sslBundleName = this.getProperty(AbstractHttpRequestFactoryProperties::getSsl, AbstractHttpRequestFactoryProperties.Ssl::getBundle, StringUtils::hasLength, null, Function.identity());
        SslBundle sslBundle = StringUtils.hasLength((String)sslBundleName) ? ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName) : this.fallbackSslBundle();
        return new ClientHttpRequestFactorySettings(redirects, connectTimeout, readTimeout, sslBundle);
    }

    private @Nullable SslBundle fallbackSslBundle() {
        return this.fallbackSettings != null ? this.fallbackSettings.sslBundle() : null;
    }

    private <T, F> @Nullable T getProperty(Function<AbstractHttpRequestFactoryProperties, @Nullable T> accessor, Predicate<@Nullable T> predicate, @Nullable F fallback, Function<F, @Nullable T> fallbackAccessor) {
        return this.getProperty(accessor, Function.identity(), predicate, fallback, fallbackAccessor);
    }

    private <P, T, F> @Nullable T getProperty(Function<AbstractHttpRequestFactoryProperties, @Nullable P> accessor, Function<P, @Nullable T> extractor, Predicate<@Nullable T> predicate, @Nullable F fallback, Function<F, @Nullable T> fallbackAccessor) {
        for (AbstractHttpRequestFactoryProperties properties : this.orderedProperties) {
            T extracted;
            if (properties == null) continue;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return fallback != null ? (T)fallbackAccessor.apply(fallback) : null;
    }
}

