/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.http.converter.autoconfigure;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * {@link ConfigurationProperties @ConfigurationProperties} for HTTP message conversion.
 *
 * @author Andy Wilkinson
 * @since 4.0.0
 */
@ConfigurationProperties("spring.http.converters")
public class HttpMessageConvertersProperties {

	/**
	 * The charset to use for String conversion.
	 */
	private Charset stringEncodingCharset = StandardCharsets.UTF_8;

	public Charset getStringEncodingCharset() {
		return this.stringEncodingCharset;
	}

	public void setStringEncodingCharset(Charset stringEncodingCharset) {
		this.stringEncodingCharset = stringEncodingCharset;
	}

}
