/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.metadata;

import java.sql.SQLException;
import oracle.ucp.jdbc.PoolDataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.jdbc.metadata.AbstractDataSourcePoolMetadata;
import org.springframework.util.StringUtils;

public class OracleUcpDataSourcePoolMetadata
extends AbstractDataSourcePoolMetadata<PoolDataSource> {
    public OracleUcpDataSourcePoolMetadata(PoolDataSource dataSource) {
        super(dataSource);
    }

    @Override
    public @Nullable Integer getActive() {
        try {
            return ((PoolDataSource)this.getDataSource()).getBorrowedConnectionsCount();
        }
        catch (SQLException ex) {
            return null;
        }
    }

    @Override
    public @Nullable Integer getIdle() {
        try {
            return ((PoolDataSource)this.getDataSource()).getAvailableConnectionsCount();
        }
        catch (SQLException ex) {
            return null;
        }
    }

    @Override
    public @Nullable Integer getMax() {
        return ((PoolDataSource)this.getDataSource()).getMaxPoolSize();
    }

    @Override
    public @Nullable Integer getMin() {
        return ((PoolDataSource)this.getDataSource()).getMinPoolSize();
    }

    @Override
    public @Nullable String getValidationQuery() {
        return ((PoolDataSource)this.getDataSource()).getSQLForValidateConnection();
    }

    @Override
    public @Nullable Boolean getDefaultAutoCommit() {
        String autoCommit = ((PoolDataSource)this.getDataSource()).getConnectionProperty("autoCommit");
        return StringUtils.hasText((String)autoCommit) ? Boolean.valueOf(autoCommit) : null;
    }
}

