/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jetty.reactive;

import jakarta.servlet.Servlet;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.springframework.boot.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.jetty.ForwardHeadersCustomizer;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.JettyWebServer;
import org.springframework.boot.jetty.JettyWebServerFactory;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.reactive.ConfigurableReactiveWebServerFactory;
import org.springframework.http.client.reactive.JettyResourceFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;

public class JettyReactiveWebServerFactory
extends JettyWebServerFactory
implements ConfigurableJettyWebServerFactory,
ConfigurableReactiveWebServerFactory {
    private static final Log logger = LogFactory.getLog(JettyReactiveWebServerFactory.class);
    private JettyResourceFactory resourceFactory;

    public JettyReactiveWebServerFactory() {
    }

    public JettyReactiveWebServerFactory(int port) {
        super(port);
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        ServletHttpHandlerAdapter servlet = new ServletHttpHandlerAdapter(httpHandler);
        Server server = this.createJettyServer(servlet);
        return new JettyWebServer(server, this.getPort() >= 0);
    }

    public void setResourceFactory(JettyResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    protected JettyResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    protected Server createJettyServer(ServletHttpHandlerAdapter servlet) {
        int port = Math.max(this.getPort(), 0);
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = new Server(this.getThreadPool());
        if (this.resourceFactory == null) {
            server.addConnector((Connector)this.createConnector(address, server));
        } else {
            server.addConnector((Connector)this.createConnector(address, server, this.resourceFactory.getExecutor(), this.resourceFactory.getScheduler(), this.resourceFactory.getByteBufferPool()));
        }
        server.setStopTimeout(0L);
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setAsyncSupported(true);
        ServletContextHandler contextHandler = new ServletContextHandler("/", false, false);
        contextHandler.addServlet(servletHolder, "/");
        server.setHandler(this.addHandlerWrappers((Handler)contextHandler));
        logger.info((Object)("Server initialized with port: " + port));
        if (this.getMaxConnections() > -1) {
            server.addBean((Object)new ConnectionLimit(this.getMaxConnections(), server));
        }
        if (Ssl.isEnabled((Ssl)this.getSsl())) {
            this.customizeSsl(server, address);
        }
        for (JettyServerCustomizer customizer : this.getServerCustomizers()) {
            customizer.customize(server);
        }
        if (this.isUseForwardHeaders()) {
            new ForwardHeadersCustomizer().customize(server);
        }
        if (this.getShutdown() == Shutdown.GRACEFUL) {
            StatisticsHandler statisticsHandler = new StatisticsHandler();
            statisticsHandler.setHandler(server.getHandler());
            server.setHandler((Handler)statisticsHandler);
        }
        return server;
    }
}

