/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.kafka.autoconfigure;

import java.util.Map;
import org.apache.kafka.streams.StreamsBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.kafka.autoconfigure.KafkaAutoConfiguration;
import org.springframework.boot.kafka.autoconfigure.KafkaConnectionDetails;
import org.springframework.boot.kafka.autoconfigure.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.kafka.config.StreamsBuilderFactoryBeanConfigurer;
import org.springframework.kafka.core.CleanupConfig;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StreamsBuilder.class})
@ConditionalOnBean(name={"defaultKafkaStreamsBuilder"})
class KafkaStreamsAnnotationDrivenConfiguration {
    private final KafkaProperties properties;

    KafkaStreamsAnnotationDrivenConfiguration(KafkaProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnMissingBean
    @Bean(value={"defaultKafkaStreamsConfig"})
    KafkaStreamsConfiguration defaultKafkaStreamsConfig(Environment environment, KafkaConnectionDetails connectionDetails) {
        Map<String, Object> properties = this.properties.buildStreamsProperties();
        this.applyKafkaConnectionDetailsForStreams(properties, connectionDetails);
        if (this.properties.getStreams().getApplicationId() == null) {
            String applicationName = environment.getProperty("spring.application.name");
            if (applicationName == null) {
                throw new InvalidConfigurationPropertyValueException("spring.kafka.streams.application-id", null, "This property is mandatory and fallback 'spring.application.name' is not set either.");
            }
            properties.put("application.id", applicationName);
        }
        return new KafkaStreamsConfiguration(properties);
    }

    @Bean
    StreamsBuilderFactoryBeanConfigurer kafkaPropertiesStreamsBuilderFactoryBeanConfigurer() {
        return new KafkaPropertiesStreamsBuilderFactoryBeanConfigurer(this.properties);
    }

    private void applyKafkaConnectionDetailsForStreams(Map<String, Object> properties, KafkaConnectionDetails connectionDetails) {
        KafkaConnectionDetails.Configuration streams = connectionDetails.getStreams();
        properties.put("bootstrap.servers", streams.getBootstrapServers());
        KafkaAutoConfiguration.applySecurityProtocol(properties, streams.getSecurityProtocol());
        KafkaAutoConfiguration.applySslBundle(properties, streams.getSslBundle());
    }

    static class KafkaPropertiesStreamsBuilderFactoryBeanConfigurer
    implements StreamsBuilderFactoryBeanConfigurer {
        private final KafkaProperties properties;

        KafkaPropertiesStreamsBuilderFactoryBeanConfigurer(KafkaProperties properties) {
            this.properties = properties;
        }

        public void configure(StreamsBuilderFactoryBean factoryBean) {
            factoryBean.setAutoStartup(this.properties.getStreams().isAutoStartup());
            KafkaProperties.Cleanup cleanup = this.properties.getStreams().getCleanup();
            CleanupConfig cleanupConfig = new CleanupConfig(cleanup.isOnStartup(), cleanup.isOnShutdown());
            factoryBean.setCleanupConfig(cleanupConfig);
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }
}

