/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase.autoconfigure;

import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.change.DatabaseChange;
import liquibase.integration.spring.Customizer;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.ui.UIServiceEnum;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.liquibase.autoconfigure.DataSourceClosingSpringLiquibase;
import org.springframework.boot.liquibase.autoconfigure.LiquibaseConnectionDetails;
import org.springframework.boot.liquibase.autoconfigure.LiquibaseDataSource;
import org.springframework.boot.liquibase.autoconfigure.LiquibaseProperties;
import org.springframework.boot.liquibase.autoconfigure.LiquibaseSchemaManagementProvider;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={SpringLiquibase.class, DatabaseChange.class})
@ConditionalOnBooleanProperty(name={"spring.liquibase.enabled"}, matchIfMissing=true)
@Conditional(value={LiquibaseDataSourceCondition.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class})
@ImportRuntimeHints(value={LiquibaseAutoConfigurationRuntimeHints.class})
public final class LiquibaseAutoConfiguration {
    @Bean
    LiquibaseSchemaManagementProvider liquibaseDefaultDdlModeProvider(ObjectProvider<SpringLiquibase> liquibases) {
        return new LiquibaseSchemaManagementProvider(liquibases);
    }

    @FunctionalInterface
    static interface SpringLiquibaseCustomizer {
        public void customize(SpringLiquibase var1);
    }

    static final class PropertiesLiquibaseConnectionDetails
    implements LiquibaseConnectionDetails {
        private final LiquibaseProperties properties;

        PropertiesLiquibaseConnectionDetails(LiquibaseProperties properties) {
            this.properties = properties;
        }

        @Override
        public @Nullable String getUsername() {
            return this.properties.getUser();
        }

        @Override
        public @Nullable String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public @Nullable String getJdbcUrl() {
            return this.properties.getUrl();
        }

        @Override
        public @Nullable String getDriverClassName() {
            String driverClassName = this.properties.getDriverClassName();
            return driverClassName != null ? driverClassName : LiquibaseConnectionDetails.super.getDriverClassName();
        }
    }

    static class LiquibaseAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        LiquibaseAutoConfigurationRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.resources().registerPattern("db/changelog/**");
        }
    }

    static final class LiquibaseDataSourceCondition
    extends AnyNestedCondition {
        LiquibaseDataSourceCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.liquibase.url"})
        private static final class LiquibaseUrlCondition {
            private LiquibaseUrlCondition() {
            }
        }

        @ConditionalOnBean(value={JdbcConnectionDetails.class})
        private static final class JdbcConnectionDetailsCondition {
            private JdbcConnectionDetailsCondition() {
            }
        }

        @ConditionalOnBean(value={DataSource.class})
        private static final class DataSourceBeanCondition {
            private DataSourceBeanCondition() {
            }
        }
    }

    @ConditionalOnClass(value={Customizer.class})
    @Configuration(proxyBeanMethods=false)
    static class CustomizerConfiguration {
        CustomizerConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Customizer.class})
        SpringLiquibaseCustomizer springLiquibaseCustomizer(Customizer<Liquibase> customizer) {
            return springLiquibase -> springLiquibase.setCustomizer(customizer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ConnectionCallback.class})
    @ConditionalOnMissingBean(value={SpringLiquibase.class})
    @EnableConfigurationProperties(value={LiquibaseProperties.class})
    static class LiquibaseConfiguration {
        LiquibaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={LiquibaseConnectionDetails.class})
        PropertiesLiquibaseConnectionDetails liquibaseConnectionDetails(LiquibaseProperties properties) {
            return new PropertiesLiquibaseConnectionDetails(properties);
        }

        @Bean
        SpringLiquibase liquibase(ObjectProvider<DataSource> dataSource, @LiquibaseDataSource ObjectProvider<DataSource> liquibaseDataSource, LiquibaseProperties properties, ObjectProvider<SpringLiquibaseCustomizer> customizers, LiquibaseConnectionDetails connectionDetails) {
            SpringLiquibase liquibase = this.createSpringLiquibase((DataSource)liquibaseDataSource.getIfAvailable(), (DataSource)dataSource.getIfUnique(), connectionDetails);
            liquibase.setChangeLog(properties.getChangeLog());
            liquibase.setClearCheckSums(properties.isClearChecksums());
            if (!CollectionUtils.isEmpty(properties.getContexts())) {
                liquibase.setContexts(StringUtils.collectionToCommaDelimitedString(properties.getContexts()));
            }
            liquibase.setDefaultSchema(properties.getDefaultSchema());
            liquibase.setLiquibaseSchema(properties.getLiquibaseSchema());
            liquibase.setLiquibaseTablespace(properties.getLiquibaseTablespace());
            liquibase.setDatabaseChangeLogTable(properties.getDatabaseChangeLogTable());
            liquibase.setDatabaseChangeLogLockTable(properties.getDatabaseChangeLogLockTable());
            liquibase.setDropFirst(properties.isDropFirst());
            liquibase.setShouldRun(properties.isEnabled());
            if (!CollectionUtils.isEmpty(properties.getLabelFilter())) {
                liquibase.setLabelFilter(StringUtils.collectionToCommaDelimitedString(properties.getLabelFilter()));
            }
            liquibase.setChangeLogParameters(properties.getParameters());
            liquibase.setRollbackFile(properties.getRollbackFile());
            liquibase.setTestRollbackOnUpdate(properties.isTestRollbackOnUpdate());
            liquibase.setTag(properties.getTag());
            if (properties.getShowSummary() != null) {
                liquibase.setShowSummary(UpdateSummaryEnum.valueOf((String)properties.getShowSummary().name()));
            }
            if (properties.getShowSummaryOutput() != null) {
                liquibase.setShowSummaryOutput(UpdateSummaryOutputEnum.valueOf((String)properties.getShowSummaryOutput().name()));
            }
            if (properties.getUiService() != null) {
                liquibase.setUiService(UIServiceEnum.valueOf((String)properties.getUiService().name()));
            }
            if (properties.getAnalyticsEnabled() != null) {
                liquibase.setAnalyticsEnabled(properties.getAnalyticsEnabled());
            }
            if (properties.getLicenseKey() != null) {
                liquibase.setLicenseKey(properties.getLicenseKey());
            }
            customizers.orderedStream().forEach(customizer -> customizer.customize(liquibase));
            return liquibase;
        }

        private SpringLiquibase createSpringLiquibase(@Nullable DataSource liquibaseDataSource, @Nullable DataSource dataSource, LiquibaseConnectionDetails connectionDetails) {
            DataSource migrationDataSource = this.getMigrationDataSource(liquibaseDataSource, dataSource, connectionDetails);
            SpringLiquibase liquibase = migrationDataSource == liquibaseDataSource || migrationDataSource == dataSource ? new SpringLiquibase() : new DataSourceClosingSpringLiquibase();
            liquibase.setDataSource(migrationDataSource);
            return liquibase;
        }

        private DataSource getMigrationDataSource(@Nullable DataSource liquibaseDataSource, @Nullable DataSource dataSource, LiquibaseConnectionDetails connectionDetails) {
            if (liquibaseDataSource != null) {
                return liquibaseDataSource;
            }
            String url = connectionDetails.getJdbcUrl();
            if (url != null) {
                DataSourceBuilder builder = DataSourceBuilder.create().type(SimpleDriverDataSource.class);
                builder.url(url);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            String user = connectionDetails.getUsername();
            if (user != null && dataSource != null) {
                DataSourceBuilder builder = DataSourceBuilder.derivedFrom((DataSource)dataSource).type(SimpleDriverDataSource.class);
                this.applyConnectionDetails(connectionDetails, builder);
                return builder.build();
            }
            Assert.state((dataSource != null ? 1 : 0) != 0, (String)"Liquibase migration DataSource missing");
            return dataSource;
        }

        private void applyConnectionDetails(LiquibaseConnectionDetails connectionDetails, DataSourceBuilder<?> builder) {
            builder.username(connectionDetails.getUsername());
            builder.password(connectionDetails.getPassword());
            String driverClassName = connectionDetails.getDriverClassName();
            if (StringUtils.hasText((String)driverClassName)) {
                builder.driverClassName(driverClassName);
            }
        }
    }
}

