/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.boot.loader.tools.JvmUtils;

public abstract class AgentAttacher {
    private static final String VIRTUAL_MACHINE_CLASSNAME = "com.sun.tools.attach.VirtualMachine";

    public static void attach(File agent) {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.substring(0, name.indexOf(64));
            ClassLoader classLoader = JvmUtils.getToolsClassLoader();
            Class<?> vmClass = classLoader.loadClass(VIRTUAL_MACHINE_CLASSNAME);
            Method attachMethod = vmClass.getDeclaredMethod("attach", String.class);
            Object vm = attachMethod.invoke(null, pid);
            Method loadAgentMethod = vmClass.getDeclaredMethod("loadAgent", String.class);
            loadAgentMethod.invoke(vm, agent.getAbsolutePath());
            vmClass.getDeclaredMethod("detach", new Class[0]).invoke(vm, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to attach agent to the JVM", ex);
        }
    }

    public static List<String> commandLineArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static boolean hasNoVerify() {
        return AgentAttacher.commandLineArguments().contains("-Xverify:none");
    }
}

