/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;

class ZipHeaderPeekInputStream
extends FilterInputStream {
    private static final byte[] ZIP_HEADER = new byte[]{80, 75, 3, 4};
    private final byte[] header = new byte[4];
    private final int headerLength;
    private int position;
    private @Nullable ByteArrayInputStream headerStream;

    protected ZipHeaderPeekInputStream(InputStream in) throws IOException {
        super(in);
        this.headerLength = in.read(this.header);
        this.headerStream = new ByteArrayInputStream(this.header, 0, this.headerLength);
    }

    @Override
    public int read() throws IOException {
        int read;
        int n = read = this.headerStream != null ? this.headerStream.read() : -1;
        if (read != -1) {
            ++this.position;
            if (this.position >= this.headerLength) {
                this.headerStream = null;
            }
            return read;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remainderRead;
        int read;
        int n = read = this.headerStream != null ? this.headerStream.read(b, off, len) : -1;
        if (read <= 0) {
            return this.readRemainder(b, off, len);
        }
        this.position += read;
        if (read < len && (remainderRead = this.readRemainder(b, off + read, len - read)) > 0) {
            read += remainderRead;
        }
        if (this.position >= this.headerLength) {
            this.headerStream = null;
        }
        return read;
    }

    boolean hasZipHeader() {
        return Arrays.equals(this.header, ZIP_HEADER);
    }

    private int readRemainder(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.position += read;
        }
        return read;
    }
}

