/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.jar;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import org.springframework.boot.loader.jar.JarEntry;
import org.springframework.boot.loader.jar.JarEntryData;
import org.springframework.boot.loader.jar.JarFile;

class JarURLConnection
extends java.net.JarURLConnection {
    static final String PROTOCOL = "jar";
    static final String SEPARATOR = "!/";
    private static final String PREFIX = "jar:file:";
    private final JarFile jarFile;
    private JarEntryData jarEntryData;
    private String jarEntryName;
    private String contentType;
    private URL jarFileUrl;

    protected JarURLConnection(URL url, JarFile jarFile) throws MalformedURLException {
        super(new URL(JarURLConnection.buildRootUrl(jarFile)));
        this.jarFile = jarFile;
        String spec = url.getFile();
        int separator = spec.lastIndexOf(SEPARATOR);
        if (separator == -1) {
            throw new MalformedURLException("no !/ found in url spec:" + spec);
        }
        if (separator + SEPARATOR.length() != spec.length()) {
            this.jarFileUrl = new URL("jar:" + spec);
            this.jarEntryName = JarURLConnection.decode(spec.substring(separator + 2));
        } else {
            this.jarFileUrl = new URL("jar:" + spec.substring(0, separator));
        }
    }

    @Override
    public URL getJarFileURL() {
        return this.jarFileUrl;
    }

    @Override
    public void connect() throws IOException {
        if (this.jarEntryName != null) {
            this.jarEntryData = this.jarFile.getJarEntryData(this.jarEntryName);
            if (this.jarEntryData == null) {
                throw new FileNotFoundException("JAR entry " + this.jarEntryName + " not found in " + this.jarFile.getName());
            }
        }
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        try {
            Manifest manifest = super.getManifest();
            return manifest;
        }
        finally {
            this.connected = false;
        }
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntryData == null ? null : this.jarEntryData.asJarEntry();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.jarEntryName == null) {
            throw new IOException("no entry name specified");
        }
        return this.jarEntryData.getInputStream();
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return this.jarEntryData == null ? this.jarFile.size() : this.jarEntryData.getSize();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        return this.jarEntryData == null ? this.jarFile : super.getContent();
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.jarEntryName == null ? "x-java/jar" : null;
            this.contentType = this.contentType == null ? JarURLConnection.guessContentTypeFromName(this.jarEntryName) : this.contentType;
            this.contentType = this.contentType == null ? "content/unknown" : this.contentType;
        }
        return this.contentType;
    }

    private static String buildRootUrl(JarFile jarFile) {
        String path = jarFile.getRootJarFile().getFile().getPath();
        StringBuilder builder = new StringBuilder(PREFIX.length() + path.length() + SEPARATOR.length());
        builder.append(PREFIX);
        builder.append(path);
        builder.append(SEPARATOR);
        return builder.toString();
    }

    private static String decode(String source) {
        int length = source.length();
        if (length == 0 || source.indexOf(37) < 0) {
            return source;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
            for (int i = 0; i < length; ++i) {
                char ch = source.charAt(i);
                if (ch == '%') {
                    if (i + 2 >= length) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    ch = JarURLConnection.decodeEscapeSequence(source, i);
                    i += 2;
                }
                bos.write(ch);
            }
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static char decodeEscapeSequence(String source, int i) {
        int hi = Character.digit(source.charAt(i + 1), 16);
        int lo = Character.digit(source.charAt(i + 2), 16);
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
        }
        return (char)((hi << 4) + lo);
    }
}

