/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.boot.loader.tools.RunProcess;
import org.springframework.boot.maven.AbstractRunMojo;
import org.springframework.boot.maven.JavaProcessExecutor;
import org.springframework.boot.maven.RunArguments;

@Mojo(name="test-run", requiresProject=true, defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class TestRunMojo
extends AbstractRunMojo {
    @Parameter(property="spring-boot.test-run.optimizedLaunch", defaultValue="true")
    private boolean optimizedLaunch;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassesDirectory;

    @Override
    protected List<File> getClassesDirectories() {
        ArrayList<File> classesDirectories = new ArrayList<File>(super.getClassesDirectories());
        classesDirectories.add(0, this.testClassesDirectory);
        return classesDirectories;
    }

    @Override
    protected boolean isUseTestClasspath() {
        return true;
    }

    @Override
    protected RunArguments resolveJvmArguments() {
        RunArguments jvmArguments = super.resolveJvmArguments();
        if (this.optimizedLaunch) {
            jvmArguments.getArgs().addFirst("-XX:TieredStopAtLevel=1");
        }
        return jvmArguments;
    }

    @Override
    protected void run(JavaProcessExecutor processExecutor, File workingDirectory, List<String> args, Map<String, String> environmentVariables) throws MojoExecutionException, MojoFailureException {
        processExecutor.withRunProcessCustomizer(runProcess -> Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller((RunProcess)runProcess)))).run(workingDirectory, args, environmentVariables);
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

