/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.testcontainers.otlp;

import org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class OpenTelemetryMetricsContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, OtlpMetricsConnectionDetails> {
    OpenTelemetryMetricsContainerConnectionDetailsFactory() {
        super("otel/opentelemetry-collector-contrib", new String[]{"org.springframework.boot.metrics.autoconfigure.export.otlp.OtlpMetricsExportAutoConfiguration"});
    }

    protected OtlpMetricsConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new OpenTelemetryMetricsContainerConnectionDetails(source);
    }

    private static final class OpenTelemetryMetricsContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements OtlpMetricsConnectionDetails {
        private OpenTelemetryMetricsContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getUrl() {
            return "http://%s:%d/v1/metrics".formatted(this.getContainer().getHost(), this.getContainer().getMappedPort(4318));
        }
    }
}

