/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.newrelic.ClientProviderType;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicInsightsAgentClientProvider;
import io.micrometer.newrelic.NewRelicInsightsApiClientProvider;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.newrelic.NewRelicProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.newrelic.NewRelicPropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={NewRelicMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="newrelic")
@EnableConfigurationProperties(value={NewRelicProperties.class})
public final class NewRelicMetricsExportAutoConfiguration {
    private final NewRelicProperties properties;

    NewRelicMetricsExportAutoConfiguration(NewRelicProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    NewRelicConfig newRelicConfig() {
        return new NewRelicPropertiesConfigAdapter(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    NewRelicClientProvider newRelicClientProvider(NewRelicConfig newRelicConfig) {
        if (newRelicConfig.clientProviderType() == ClientProviderType.INSIGHTS_AGENT) {
            return new NewRelicInsightsAgentClientProvider(newRelicConfig);
        }
        return new NewRelicInsightsApiClientProvider(newRelicConfig, (HttpSender)new HttpUrlConnectionSender(this.properties.getConnectTimeout(), this.properties.getReadTimeout()));
    }

    @Bean
    @ConditionalOnMissingBean
    NewRelicMeterRegistry newRelicMeterRegistry(NewRelicConfig newRelicConfig, Clock clock, NewRelicClientProvider newRelicClientProvider) {
        return NewRelicMeterRegistry.builder((NewRelicConfig)newRelicConfig).clock(clock).clientProvider(newRelicClientProvider).build();
    }
}

